-- Veritabanı Yedekleme
-- Oluşturulma Tarihi: 2025-03-13 23:40:50
-- Veritabanı: ozatweb_qr

SET FOREIGN_KEY_CHECKS=0;

-- Tablo yapısı: admin
DROP TABLE IF EXISTS `admin`;
CREATE TABLE `admin` (
  `id` int NOT NULL AUTO_INCREMENT,
  `kullanici_adi` varchar(50) NOT NULL,
  `sifre` varchar(32) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `kullanici_adi` (`kullanici_adi`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Tablo verisi: admin
INSERT INTO `admin` VALUES ('1', 'admin', '0192023a7bbd73250516f069df18b500', '2025-02-28 14:33:33');

-- Tablo yapısı: ayarlar
DROP TABLE IF EXISTS `ayarlar`;
CREATE TABLE `ayarlar` (
  `id` int NOT NULL AUTO_INCREMENT,
  `isletme_adi` varchar(255) DEFAULT NULL,
  `adres` text,
  `telefon` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `haftaici_saatler` varchar(100) DEFAULT NULL,
  `haftasonu_saatler` varchar(100) DEFAULT NULL,
  `facebook` varchar(255) DEFAULT NULL,
  `facebook_kullanici` varchar(255) DEFAULT NULL,
  `instagram` varchar(255) DEFAULT NULL,
  `instagram_kullanici` varchar(255) DEFAULT NULL,
  `twitter` varchar(255) DEFAULT NULL,
  `twitter_kullanici` varchar(255) DEFAULT NULL,
  `whatsapp` varchar(20) DEFAULT NULL COMMENT 'WhatsApp numarası (Örn: 05551234567 veya 5551234567)',
  `logo` varchar(255) DEFAULT NULL,
  `magaza_foto` varchar(255) DEFAULT NULL,
  `copyright` text,
  `magaza_url` varchar(255) DEFAULT NULL,
  `wifi_ag_adi` varchar(100) DEFAULT NULL,
  `wifi_sifre` varchar(100) DEFAULT NULL,
  `wifi_guvenlik` varchar(50) DEFAULT 'WPA2',
  `header_bg_color` varchar(20) DEFAULT '#343a40',
  `bottom_bar_bg_color` varchar(20) DEFAULT '#000000',
  `feedback_circle_color` varchar(20) DEFAULT '#dc3545',
  `sidebar_bg_color` varchar(20) DEFAULT '#343a40',
  `header_icon_color` varchar(20) DEFAULT '#ffffff',
  `bottom_bar_icon_color` varchar(20) DEFAULT '#ffffff',
  `qr_arkaplan` varchar(255) DEFAULT NULL,
  `site_basligi` varchar(255) DEFAULT NULL,
  `site_aciklamasi` text,
  `site_etiketleri` varchar(255) DEFAULT NULL,
  `favicon` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Tablo verisi: ayarlar
INSERT INTO `ayarlar` VALUES ('1', 'Ozatweb', 'İstiklal Caddesi 255 Sokak No 56 Tuzla/İstanbul', '0551 070 59 88', 'info@ozatweb.tr', '09:00-18:00', NULL, 'https://facebook.com/ozatweb', 'ozatweb', 'https://instagram.com/ozatweb', 'ozatweb', 'https://twitter.com/ozatweb', 'ozatweb', '5510705988', 'logo.png', 'magaza_foto_1741895457.jpg', 'Ozatweb ile Oluşturulmuştur.<br>© 2020-2024', 'https://google.com', 'cafe wifii', 'cafe1234', 'WPA2', '#ffffff', '#343a40', '#fd1c1c', NULL, '#000000', '#ffffff', 'qr_arkaplan_1740836635.jpg', 'Ozatweb', 'QR Menü Açıklama.', 'etiket.', 'favicon.ico');

-- Tablo yapısı: kategoriler
DROP TABLE IF EXISTS `kategoriler`;
CREATE TABLE `kategoriler` (
  `id` int NOT NULL AUTO_INCREMENT,
  `kategori_adi` varchar(100) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Tablo verisi: kategoriler
INSERT INTO `kategoriler` VALUES ('13', 'Kahvaltı', '2025-03-13 21:59:21');
INSERT INTO `kategoriler` VALUES ('14', 'Salatalar', '2025-03-13 22:01:22');
INSERT INTO `kategoriler` VALUES ('15', 'Burgerler', '2025-03-13 22:02:16');
INSERT INTO `kategoriler` VALUES ('16', 'Steak', '2025-03-13 22:03:18');
INSERT INTO `kategoriler` VALUES ('17', 'Kebap & Dürüm', '2025-03-13 22:06:53');
INSERT INTO `kategoriler` VALUES ('18', 'TAVUKLU YEMEKLER', '2025-03-13 22:08:19');
INSERT INTO `kategoriler` VALUES ('19', 'PİZZALAR', '2025-03-13 22:09:15');
INSERT INTO `kategoriler` VALUES ('20', 'PİDELER', '2025-03-13 22:10:23');
INSERT INTO `kategoriler` VALUES ('21', 'MAKARNALAR', '2025-03-13 22:11:03');
INSERT INTO `kategoriler` VALUES ('22', 'APERATİFLER', '2025-03-13 22:12:16');
INSERT INTO `kategoriler` VALUES ('23', 'ÇORBALAR', '2025-03-13 22:12:41');
INSERT INTO `kategoriler` VALUES ('24', 'KAHVELER', '2025-03-13 22:13:06');
INSERT INTO `kategoriler` VALUES ('25', 'SICAK İÇECEKLER', '2025-03-13 22:14:18');
INSERT INTO `kategoriler` VALUES ('26', 'SOĞUK İÇECEKLER', '2025-03-13 22:14:37');
INSERT INTO `kategoriler` VALUES ('27', 'TATLILAR', '2025-03-13 22:15:18');
INSERT INTO `kategoriler` VALUES ('28', 'NARGİLELER', '2025-03-13 22:15:55');

-- Tablo yapısı: masalar
DROP TABLE IF EXISTS `masalar`;
CREATE TABLE `masalar` (
  `id` int NOT NULL AUTO_INCREMENT,
  `masa_no` int NOT NULL,
  `masa_adi` varchar(100) DEFAULT NULL,
  `masa_aciklama` text,
  `benzersiz_kod` varchar(50) NOT NULL,
  `olusturma_tarihi` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `benzersiz_kod` (`benzersiz_kod`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Tablo verisi: masalar
INSERT INTO `masalar` VALUES ('1', '1', 'VIP Masa', '1', '5568cd68440ff379f034366f3af212b0', '2025-03-01 16:04:12');
INSERT INTO `masalar` VALUES ('2', '2', '2', '2', '63f446373fee3132e5709f5136010ddb', '2025-03-01 16:12:43');

-- Tablo yapısı: sikayetler
DROP TABLE IF EXISTS `sikayetler`;
CREATE TABLE `sikayetler` (
  `id` int NOT NULL AUTO_INCREMENT,
  `musteri_adi` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `konu` varchar(200) NOT NULL,
  `mesaj` text NOT NULL,
  `okundu` tinyint(1) DEFAULT '0',
  `tarih` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Tablo verisi: sikayetler
INSERT INTO `sikayetler` VALUES ('1', 'tetet', 'sdadas@mail.com', 'sadsa', 'sadsa', '1', '2025-02-28 14:39:38');
INSERT INTO `sikayetler` VALUES ('2', 'asdsad', 'adasdsa@mail.com', 'sadsa', 'asdsa', '0', '2025-02-28 21:53:47');
INSERT INTO `sikayetler` VALUES ('3', 'asdsa', 'dada@mail.com', 'sadsad', 'asdas', '1', '2025-02-28 21:54:01');

-- Tablo yapısı: site_ziyaretleri
DROP TABLE IF EXISTS `site_ziyaretleri`;
CREATE TABLE `site_ziyaretleri` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ip_adresi` varchar(45) DEFAULT NULL,
  `tarih` datetime DEFAULT CURRENT_TIMESTAMP,
  `sayfa` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=545 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Tablo verisi: site_ziyaretleri
INSERT INTO `site_ziyaretleri` VALUES ('1', '176.234.135.50', '2025-03-01 07:19:33', '/');
INSERT INTO `site_ziyaretleri` VALUES ('2', '176.234.135.50', '2025-03-01 07:20:32', '/');
INSERT INTO `site_ziyaretleri` VALUES ('3', '176.234.135.50', '2025-03-01 07:21:35', '/');
INSERT INTO `site_ziyaretleri` VALUES ('4', '176.234.135.50', '2025-03-01 07:23:48', '/');
INSERT INTO `site_ziyaretleri` VALUES ('5', '176.234.135.50', '2025-03-01 07:25:17', '/');
INSERT INTO `site_ziyaretleri` VALUES ('6', '176.234.135.50', '2025-03-01 07:29:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('7', '176.234.135.50', '2025-03-01 07:30:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('8', '176.234.135.50', '2025-03-01 07:30:05', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('9', '176.234.135.50', '2025-03-01 07:31:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('10', '176.234.135.50', '2025-03-01 07:31:03', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('11', '176.234.135.50', '2025-03-01 07:31:05', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('12', '176.234.135.50', '2025-03-01 07:31:08', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('13', '176.234.135.50', '2025-03-01 07:31:11', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('14', '176.234.135.50', '2025-03-01 07:31:14', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('15', '176.234.135.50', '2025-03-01 07:31:17', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('16', '176.234.135.50', '2025-03-01 07:32:03', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('17', '176.234.135.50', '2025-03-01 07:32:11', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('18', '176.234.135.50', '2025-03-01 07:32:54', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('19', '176.234.135.50', '2025-03-01 07:34:33', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('20', '176.234.135.50', '2025-03-01 07:35:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('21', '176.234.135.50', '2025-03-01 07:35:46', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('22', '176.234.135.50', '2025-03-01 07:36:56', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('23', '176.234.135.50', '2025-03-01 07:37:45', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('24', '176.234.135.50', '2025-03-01 07:37:49', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('25', '176.234.135.50', '2025-03-01 07:38:48', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('26', '176.234.135.50', '2025-03-01 07:39:03', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('27', '176.234.135.50', '2025-03-01 07:40:40', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('28', '176.234.135.50', '2025-03-01 07:40:54', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('29', '176.234.135.50', '2025-03-01 07:42:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('30', '176.234.135.50', '2025-03-01 07:43:15', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('31', '176.234.135.50', '2025-03-01 07:44:23', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('32', '176.234.135.50', '2025-03-01 07:44:30', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('33', '176.234.135.50', '2025-03-01 07:48:54', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('34', '176.234.135.50', '2025-03-01 07:49:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('35', '176.234.135.50', '2025-03-01 07:49:26', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('36', '176.234.135.50', '2025-03-01 07:49:33', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('37', '176.234.135.50', '2025-03-01 07:52:47', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('38', '176.234.135.50', '2025-03-01 07:54:14', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('39', '176.234.135.50', '2025-03-01 07:55:15', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('40', '176.234.135.50', '2025-03-01 07:56:16', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('41', '176.234.135.50', '2025-03-01 07:57:32', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('42', '176.234.135.50', '2025-03-01 07:57:35', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('43', '176.234.135.50', '2025-03-01 07:58:41', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('44', '176.234.135.50', '2025-03-01 07:59:42', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('45', '176.234.135.50', '2025-03-01 07:59:55', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('46', '176.234.135.50', '2025-03-01 08:01:17', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('47', '176.234.135.50', '2025-03-01 08:02:14', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('48', '176.234.135.50', '2025-03-01 08:05:05', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('49', '176.234.135.50', '2025-03-01 08:05:22', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('50', '176.234.135.50', '2025-03-01 08:07:35', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('51', '176.234.135.50', '2025-03-01 08:09:43', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('52', '176.234.135.50', '2025-03-01 08:10:02', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('53', '176.234.135.50', '2025-03-01 08:11:39', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('54', '176.234.135.50', '2025-03-01 08:11:58', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('55', '176.234.135.50', '2025-03-01 08:14:24', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('56', '176.234.135.50', '2025-03-01 08:18:12', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('57', '176.234.135.50', '2025-03-01 08:21:20', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('58', '176.234.135.50', '2025-03-01 08:22:41', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('59', '176.234.135.50', '2025-03-01 08:23:18', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('60', '176.234.135.50', '2025-03-01 08:23:21', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('61', '176.234.135.50', '2025-03-01 08:24:53', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('62', '176.234.135.50', '2025-03-01 08:25:14', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('63', '176.234.135.50', '2025-03-01 08:28:37', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('64', '176.234.135.50', '2025-03-01 08:28:40', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('65', '176.234.135.50', '2025-03-01 08:28:45', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('66', '176.234.135.50', '2025-03-01 08:29:04', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('67', '176.234.135.50', '2025-03-01 08:30:06', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('68', '176.234.135.50', '2025-03-01 08:30:09', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('69', '176.234.135.50', '2025-03-01 08:30:10', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('70', '176.234.135.50', '2025-03-01 08:30:11', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('71', '176.234.135.50', '2025-03-01 08:30:15', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('72', '176.234.135.50', '2025-03-01 08:30:16', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('73', '176.234.135.50', '2025-03-01 08:30:32', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('74', '176.234.135.50', '2025-03-01 08:30:34', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('75', '176.234.135.50', '2025-03-01 08:30:45', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('76', '176.234.135.50', '2025-03-01 08:32:18', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('77', '176.234.135.50', '2025-03-01 08:32:21', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('78', '176.234.135.50', '2025-03-01 08:32:23', '/');
INSERT INTO `site_ziyaretleri` VALUES ('79', '176.234.135.50', '2025-03-01 08:32:25', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('80', '176.234.135.50', '2025-03-01 08:32:28', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('81', '176.234.135.50', '2025-03-01 08:32:28', '/');
INSERT INTO `site_ziyaretleri` VALUES ('82', '176.234.135.50', '2025-03-01 08:32:39', '/');
INSERT INTO `site_ziyaretleri` VALUES ('83', '176.234.135.50', '2025-03-01 08:32:44', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('84', '176.234.135.50', '2025-03-01 08:35:34', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('85', '176.234.135.50', '2025-03-01 08:35:47', '/');
INSERT INTO `site_ziyaretleri` VALUES ('86', '176.234.135.50', '2025-03-01 08:35:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('87', '176.234.135.50', '2025-03-01 08:36:22', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('88', '176.234.135.50', '2025-03-01 08:38:38', '/');
INSERT INTO `site_ziyaretleri` VALUES ('89', '176.234.135.50', '2025-03-01 08:38:42', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('90', '176.234.135.50', '2025-03-01 08:38:53', '/');
INSERT INTO `site_ziyaretleri` VALUES ('91', '176.234.135.50', '2025-03-01 08:39:10', '/');
INSERT INTO `site_ziyaretleri` VALUES ('92', '176.234.135.50', '2025-03-01 08:39:18', '/');
INSERT INTO `site_ziyaretleri` VALUES ('93', '176.234.135.50', '2025-03-01 08:39:39', '/');
INSERT INTO `site_ziyaretleri` VALUES ('94', '176.234.135.50', '2025-03-01 08:41:02', '/');
INSERT INTO `site_ziyaretleri` VALUES ('95', '176.234.135.50', '2025-03-01 08:41:42', '/');
INSERT INTO `site_ziyaretleri` VALUES ('96', '176.234.135.50', '2025-03-01 08:41:45', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('97', '176.234.135.50', '2025-03-01 08:41:48', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('98', '176.234.135.50', '2025-03-01 08:41:58', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('99', '176.234.135.50', '2025-03-01 08:43:16', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('100', '176.234.135.50', '2025-03-01 08:43:34', '/');
INSERT INTO `site_ziyaretleri` VALUES ('101', '176.234.135.50', '2025-03-01 08:43:42', '/');
INSERT INTO `site_ziyaretleri` VALUES ('102', '176.234.135.50', '2025-03-01 08:43:44', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('103', '176.234.135.50', '2025-03-01 08:43:56', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('104', '176.234.135.50', '2025-03-01 08:44:20', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('105', '176.234.135.50', '2025-03-01 08:44:33', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('106', '176.234.135.50', '2025-03-01 08:46:31', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('107', '176.234.135.50', '2025-03-01 08:47:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('108', '176.234.135.50', '2025-03-01 08:47:06', '/');
INSERT INTO `site_ziyaretleri` VALUES ('109', '176.234.135.50', '2025-03-01 08:47:25', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('110', '176.234.135.50', '2025-03-01 08:47:41', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('111', '176.234.135.50', '2025-03-01 08:47:45', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('112', '176.234.135.50', '2025-03-01 08:47:54', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('113', '176.234.135.50', '2025-03-01 08:48:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('114', '176.234.135.50', '2025-03-01 08:49:59', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('115', '176.234.135.50', '2025-03-01 08:50:10', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('116', '176.234.135.50', '2025-03-01 08:53:46', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('117', '176.234.135.50', '2025-03-01 08:55:27', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('118', '176.234.135.50', '2025-03-01 08:55:39', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('119', '176.234.135.50', '2025-03-01 08:56:20', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('120', '176.234.135.50', '2025-03-01 08:57:30', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('121', '176.234.135.50', '2025-03-01 08:57:43', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('122', '176.234.135.50', '2025-03-01 08:57:53', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('123', '176.234.135.50', '2025-03-01 08:58:20', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('124', '176.234.135.50', '2025-03-01 09:00:31', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('125', '176.234.135.50', '2025-03-01 09:00:52', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('126', '66.249.93.38', '2025-03-01 09:01:03', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('127', '66.249.93.38', '2025-03-01 09:01:33', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('128', '66.249.93.37', '2025-03-01 09:02:23', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('129', '176.234.135.50', '2025-03-01 09:03:05', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('130', '176.234.135.50', '2025-03-01 09:04:29', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('131', '176.234.135.50', '2025-03-01 09:04:57', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('132', '66.249.93.37', '2025-03-01 09:05:01', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('133', '176.234.135.50', '2025-03-01 09:05:16', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('134', '66.249.93.37', '2025-03-01 09:05:19', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('135', '66.249.93.38', '2025-03-01 09:05:30', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('136', '176.234.135.50', '2025-03-01 09:05:34', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('137', '176.234.135.50', '2025-03-01 09:05:37', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('138', '66.249.93.38', '2025-03-01 09:05:40', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('139', '176.234.135.50', '2025-03-01 09:06:24', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('140', '176.234.135.50', '2025-03-01 09:07:03', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('141', '176.234.135.50', '2025-03-01 09:07:14', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('142', '176.234.135.50', '2025-03-01 09:09:45', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('143', '176.234.135.50', '2025-03-01 09:10:02', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('144', '176.234.135.50', '2025-03-01 09:10:53', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('145', '176.234.135.50', '2025-03-01 09:11:04', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('146', '176.234.135.50', '2025-03-01 09:11:19', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('147', '176.234.135.50', '2025-03-01 09:12:20', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('148', '176.234.135.50', '2025-03-01 09:12:29', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('149', '176.234.135.50', '2025-03-01 09:12:31', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('150', '176.234.135.50', '2025-03-01 09:12:47', '/');
INSERT INTO `site_ziyaretleri` VALUES ('151', '176.234.135.50', '2025-03-01 09:12:49', '/');
INSERT INTO `site_ziyaretleri` VALUES ('152', '176.234.135.50', '2025-03-01 09:16:06', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('153', '185.88.36.112', '2025-03-01 09:16:07', '/');
INSERT INTO `site_ziyaretleri` VALUES ('154', '185.88.36.112', '2025-03-01 09:16:09', '/');
INSERT INTO `site_ziyaretleri` VALUES ('155', '176.234.135.50', '2025-03-01 09:16:15', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('156', '176.234.135.50', '2025-03-01 09:18:58', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('157', '176.234.135.50', '2025-03-01 09:19:23', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('158', '176.234.135.50', '2025-03-01 09:19:34', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('159', '176.234.135.50', '2025-03-01 09:21:16', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('160', '176.234.135.50', '2025-03-01 09:21:22', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('161', '176.234.135.50', '2025-03-01 09:21:44', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('162', '176.234.135.50', '2025-03-01 09:23:24', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('163', '176.234.135.50', '2025-03-01 09:23:40', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('164', '176.234.135.50', '2025-03-01 09:24:07', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('165', '176.234.135.50', '2025-03-01 09:24:25', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('166', '176.234.135.50', '2025-03-01 09:24:37', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('167', '176.234.135.50', '2025-03-01 09:24:44', '/');
INSERT INTO `site_ziyaretleri` VALUES ('168', '176.234.135.50', '2025-03-01 09:24:48', '/');
INSERT INTO `site_ziyaretleri` VALUES ('169', '176.234.135.50', '2025-03-01 09:24:51', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('170', '176.234.135.50', '2025-03-01 09:24:59', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('171', '176.234.135.50', '2025-03-01 09:25:03', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('172', '176.234.135.50', '2025-03-01 09:25:13', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('173', '176.234.135.50', '2025-03-01 09:25:26', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('174', '176.234.135.50', '2025-03-01 09:25:34', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('175', '176.234.135.50', '2025-03-01 09:25:53', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('176', '176.234.135.50', '2025-03-01 09:26:14', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('177', '176.234.135.50', '2025-03-01 09:26:45', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('178', '176.234.135.50', '2025-03-01 09:26:56', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('179', '176.234.135.50', '2025-03-01 09:27:42', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('180', '176.234.135.50', '2025-03-01 09:27:50', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('181', '176.234.135.50', '2025-03-01 09:28:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('182', '176.234.135.50', '2025-03-01 09:28:16', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('183', '176.234.135.50', '2025-03-01 09:28:20', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('184', '176.234.135.50', '2025-03-01 09:28:27', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('185', '176.234.135.50', '2025-03-01 09:28:37', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('186', '176.234.135.50', '2025-03-01 09:28:58', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('187', '176.234.135.50', '2025-03-01 09:29:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('188', '176.234.135.50', '2025-03-01 09:29:52', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('189', '176.234.135.50', '2025-03-01 09:29:56', '/');
INSERT INTO `site_ziyaretleri` VALUES ('190', '176.234.135.50', '2025-03-01 09:31:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('191', '176.234.135.50', '2025-03-01 09:31:22', '/');
INSERT INTO `site_ziyaretleri` VALUES ('192', '176.234.135.50', '2025-03-01 09:31:33', '/');
INSERT INTO `site_ziyaretleri` VALUES ('193', '176.234.135.50', '2025-03-01 09:31:45', '/');
INSERT INTO `site_ziyaretleri` VALUES ('194', '176.234.135.50', '2025-03-01 09:31:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('195', '176.234.135.50', '2025-03-01 09:31:53', '/');
INSERT INTO `site_ziyaretleri` VALUES ('196', '176.234.135.50', '2025-03-01 09:32:46', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('197', '176.234.135.50', '2025-03-01 09:32:48', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('198', '176.234.135.50', '2025-03-01 09:33:37', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('199', '176.234.135.50', '2025-03-01 09:33:50', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('200', '176.234.135.50', '2025-03-01 09:35:15', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('201', '176.234.135.50', '2025-03-01 09:35:58', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('202', '176.234.135.50', '2025-03-01 09:36:17', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('203', '176.234.135.50', '2025-03-01 09:37:21', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('204', '176.234.135.50', '2025-03-01 09:37:28', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('205', '176.234.135.50', '2025-03-01 09:40:15', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('206', '87.236.176.225', '2025-03-01 10:53:59', '/');
INSERT INTO `site_ziyaretleri` VALUES ('207', '185.213.155.202', '2025-03-01 12:35:29', '/');
INSERT INTO `site_ziyaretleri` VALUES ('208', '35.94.238.56', '2025-03-01 14:19:00', '/');
INSERT INTO `site_ziyaretleri` VALUES ('209', '37.19.200.165', '2025-03-01 14:36:58', '/');
INSERT INTO `site_ziyaretleri` VALUES ('210', '87.236.176.71', '2025-03-01 14:53:13', '/');
INSERT INTO `site_ziyaretleri` VALUES ('211', '176.234.135.50', '2025-03-01 15:02:23', '/');
INSERT INTO `site_ziyaretleri` VALUES ('212', '176.234.135.50', '2025-03-01 15:06:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('213', '176.234.135.50', '2025-03-01 15:07:28', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('214', '176.234.135.50', '2025-03-01 15:07:48', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('215', '176.234.135.50', '2025-03-01 15:08:58', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('216', '176.234.135.50', '2025-03-01 15:09:21', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('217', '176.234.135.50', '2025-03-01 15:09:35', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('218', '176.234.135.50', '2025-03-01 15:09:51', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('219', '176.234.135.50', '2025-03-01 15:10:48', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('220', '176.234.135.50', '2025-03-01 15:11:20', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('221', '176.234.135.50', '2025-03-01 15:11:29', '/');
INSERT INTO `site_ziyaretleri` VALUES ('222', '176.89.106.172', '2025-03-01 15:11:35', '/');
INSERT INTO `site_ziyaretleri` VALUES ('223', '176.89.106.172', '2025-03-01 15:11:46', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('224', '176.89.106.172', '2025-03-01 15:12:02', '/');
INSERT INTO `site_ziyaretleri` VALUES ('225', '176.89.106.172', '2025-03-01 15:12:10', '/');
INSERT INTO `site_ziyaretleri` VALUES ('226', '176.89.106.172', '2025-03-01 15:12:12', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('227', '176.89.106.172', '2025-03-01 15:12:17', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('228', '176.89.106.172', '2025-03-01 15:13:39', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('229', '176.89.106.172', '2025-03-01 15:14:46', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('230', '176.89.106.172', '2025-03-01 15:14:50', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('231', '176.89.106.172', '2025-03-01 15:15:00', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('232', '91.84.87.137', '2025-03-01 15:16:59', '/');
INSERT INTO `site_ziyaretleri` VALUES ('233', '91.84.87.137', '2025-03-01 15:17:51', '/');
INSERT INTO `site_ziyaretleri` VALUES ('234', '176.89.106.172', '2025-03-01 15:18:41', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('235', '176.89.106.172', '2025-03-01 15:20:53', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('236', '176.234.135.50', '2025-03-01 15:34:08', '/');
INSERT INTO `site_ziyaretleri` VALUES ('237', '176.234.135.50', '2025-03-01 15:40:24', '/');
INSERT INTO `site_ziyaretleri` VALUES ('238', '176.234.135.50', '2025-03-01 15:41:12', '/');
INSERT INTO `site_ziyaretleri` VALUES ('239', '176.234.135.50', '2025-03-01 15:42:16', '/');
INSERT INTO `site_ziyaretleri` VALUES ('240', '176.234.135.50', '2025-03-01 15:47:49', '/');
INSERT INTO `site_ziyaretleri` VALUES ('241', '176.89.106.172', '2025-03-01 15:48:02', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('242', '176.89.106.172', '2025-03-01 15:48:37', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('243', '176.89.106.172', '2025-03-01 15:52:10', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('244', '176.89.106.172', '2025-03-01 15:58:44', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('245', '176.234.135.50', '2025-03-01 16:00:54', '/');
INSERT INTO `site_ziyaretleri` VALUES ('246', '176.89.106.172', '2025-03-01 16:07:13', '/?masa=5568cd68440ff379f034366f3af212b0');
INSERT INTO `site_ziyaretleri` VALUES ('247', '23.27.145.238', '2025-03-01 16:14:35', '/');
INSERT INTO `site_ziyaretleri` VALUES ('248', '23.27.145.119', '2025-03-01 16:14:56', '/');
INSERT INTO `site_ziyaretleri` VALUES ('249', '176.89.106.172', '2025-03-01 16:17:43', '/?masa=5568cd68440ff379f034366f3af212b0');
INSERT INTO `site_ziyaretleri` VALUES ('250', '34.201.148.202', '2025-03-01 16:46:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('251', '176.234.135.50', '2025-03-01 16:47:31', '/');
INSERT INTO `site_ziyaretleri` VALUES ('252', '176.234.135.50', '2025-03-01 16:50:27', '/');
INSERT INTO `site_ziyaretleri` VALUES ('253', '176.89.106.172', '2025-03-01 16:52:41', '/?masa=5568cd68440ff379f034366f3af212b0');
INSERT INTO `site_ziyaretleri` VALUES ('254', '176.89.106.172', '2025-03-01 16:52:53', '/');
INSERT INTO `site_ziyaretleri` VALUES ('255', '176.89.106.172', '2025-03-01 16:53:26', '/');
INSERT INTO `site_ziyaretleri` VALUES ('256', '176.89.106.172', '2025-03-01 17:17:05', '/');
INSERT INTO `site_ziyaretleri` VALUES ('257', '176.89.106.172', '2025-03-01 17:20:20', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('258', '176.89.106.172', '2025-03-01 17:22:27', '/');
INSERT INTO `site_ziyaretleri` VALUES ('259', '176.89.106.172', '2025-03-01 17:22:39', '/');
INSERT INTO `site_ziyaretleri` VALUES ('260', '176.89.106.172', '2025-03-01 17:24:17', '/');
INSERT INTO `site_ziyaretleri` VALUES ('261', '176.89.106.172', '2025-03-01 17:27:22', '/');
INSERT INTO `site_ziyaretleri` VALUES ('262', '176.89.106.172', '2025-03-01 17:27:35', '/');
INSERT INTO `site_ziyaretleri` VALUES ('263', '176.89.106.172', '2025-03-01 17:27:46', '/');
INSERT INTO `site_ziyaretleri` VALUES ('264', '176.89.106.172', '2025-03-01 17:28:51', '/');
INSERT INTO `site_ziyaretleri` VALUES ('265', '176.89.106.172', '2025-03-01 17:29:18', '/');
INSERT INTO `site_ziyaretleri` VALUES ('266', '176.89.106.172', '2025-03-01 17:30:12', '/');
INSERT INTO `site_ziyaretleri` VALUES ('267', '176.89.106.172', '2025-03-01 17:30:53', '/');
INSERT INTO `site_ziyaretleri` VALUES ('268', '176.89.106.172', '2025-03-01 17:33:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('269', '176.89.106.172', '2025-03-01 17:33:15', '/');
INSERT INTO `site_ziyaretleri` VALUES ('270', '78.190.131.167', '2025-03-01 17:33:27', '/');
INSERT INTO `site_ziyaretleri` VALUES ('271', '13.212.141.108', '2025-03-01 17:33:38', '/');
INSERT INTO `site_ziyaretleri` VALUES ('272', '151.135.7.90', '2025-03-01 17:35:36', '/');
INSERT INTO `site_ziyaretleri` VALUES ('273', '176.89.106.172', '2025-03-01 17:49:35', '/');
INSERT INTO `site_ziyaretleri` VALUES ('274', '168.119.80.126', '2025-03-01 17:51:28', '/');
INSERT INTO `site_ziyaretleri` VALUES ('275', '138.201.135.169', '2025-03-01 17:52:40', '/');
INSERT INTO `site_ziyaretleri` VALUES ('276', '138.201.135.169', '2025-03-01 17:52:40', '/');
INSERT INTO `site_ziyaretleri` VALUES ('277', '209.97.134.225', '2025-03-01 19:09:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('278', '209.97.134.225', '2025-03-01 19:09:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('279', '176.89.106.172', '2025-03-01 19:52:28', '/');
INSERT INTO `site_ziyaretleri` VALUES ('280', '176.89.106.172', '2025-03-01 20:26:59', '/');
INSERT INTO `site_ziyaretleri` VALUES ('281', '176.89.106.172', '2025-03-01 21:10:07', '/');
INSERT INTO `site_ziyaretleri` VALUES ('282', '3.84.36.94', '2025-03-01 21:22:43', '/');
INSERT INTO `site_ziyaretleri` VALUES ('283', '176.234.135.50', '2025-03-01 22:37:43', '/');
INSERT INTO `site_ziyaretleri` VALUES ('284', '176.89.106.172', '2025-03-01 23:16:28', '/');
INSERT INTO `site_ziyaretleri` VALUES ('285', '185.247.137.227', '2025-03-01 23:45:12', '/');
INSERT INTO `site_ziyaretleri` VALUES ('286', '176.234.135.50', '2025-03-01 23:55:05', '/');
INSERT INTO `site_ziyaretleri` VALUES ('287', '176.89.106.172', '2025-03-02 00:28:22', '/');
INSERT INTO `site_ziyaretleri` VALUES ('288', '176.234.135.50', '2025-03-02 00:28:26', '/');
INSERT INTO `site_ziyaretleri` VALUES ('289', '176.89.106.172', '2025-03-02 00:30:31', '/');
INSERT INTO `site_ziyaretleri` VALUES ('290', '185.247.137.94', '2025-03-02 01:36:30', '/');
INSERT INTO `site_ziyaretleri` VALUES ('291', '176.234.135.50', '2025-03-02 04:35:10', '/');
INSERT INTO `site_ziyaretleri` VALUES ('292', '64.227.66.218', '2025-03-02 05:11:55', '/');
INSERT INTO `site_ziyaretleri` VALUES ('293', '64.227.66.218', '2025-03-02 05:11:56', '/');
INSERT INTO `site_ziyaretleri` VALUES ('294', '185.247.137.20', '2025-03-02 06:23:25', '/');
INSERT INTO `site_ziyaretleri` VALUES ('295', '82.197.68.199', '2025-03-02 14:00:48', '/');
INSERT INTO `site_ziyaretleri` VALUES ('296', '82.197.68.199', '2025-03-02 14:00:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('297', '104.152.52.61', '2025-03-02 14:19:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('298', '176.234.135.50', '2025-03-02 14:20:40', '/');
INSERT INTO `site_ziyaretleri` VALUES ('299', '52.11.171.106', '2025-03-02 15:30:09', '/');
INSERT INTO `site_ziyaretleri` VALUES ('300', '91.84.87.137', '2025-03-02 15:30:10', '/');
INSERT INTO `site_ziyaretleri` VALUES ('301', '91.84.87.137', '2025-03-02 15:31:38', '/');
INSERT INTO `site_ziyaretleri` VALUES ('302', '206.189.178.102', '2025-03-02 16:06:40', '/');
INSERT INTO `site_ziyaretleri` VALUES ('303', '206.189.178.102', '2025-03-02 16:06:41', '/');
INSERT INTO `site_ziyaretleri` VALUES ('304', '23.27.145.147', '2025-03-02 17:00:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('305', '23.27.145.85', '2025-03-02 17:01:38', '/');
INSERT INTO `site_ziyaretleri` VALUES ('306', '13.228.73.249', '2025-03-03 02:19:32', '/');
INSERT INTO `site_ziyaretleri` VALUES ('307', '13.228.73.249', '2025-03-03 02:19:34', '/');
INSERT INTO `site_ziyaretleri` VALUES ('308', '13.228.73.249', '2025-03-03 02:38:33', '/');
INSERT INTO `site_ziyaretleri` VALUES ('309', '13.228.73.249', '2025-03-03 02:38:34', '/');
INSERT INTO `site_ziyaretleri` VALUES ('310', '13.228.73.249', '2025-03-03 04:13:49', '/');
INSERT INTO `site_ziyaretleri` VALUES ('311', '13.228.73.249', '2025-03-03 04:13:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('312', '31.141.80.77', '2025-03-03 12:24:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('313', '176.234.135.50', '2025-03-03 12:52:56', '/');
INSERT INTO `site_ziyaretleri` VALUES ('314', '176.234.135.50', '2025-03-03 12:52:59', '/');
INSERT INTO `site_ziyaretleri` VALUES ('315', '176.234.135.50', '2025-03-03 12:53:06', '/');
INSERT INTO `site_ziyaretleri` VALUES ('316', '176.234.135.50', '2025-03-03 12:53:09', '/');
INSERT INTO `site_ziyaretleri` VALUES ('317', '176.234.135.50', '2025-03-03 12:53:49', '/');
INSERT INTO `site_ziyaretleri` VALUES ('318', '176.234.135.50', '2025-03-03 12:56:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('319', '176.234.135.50', '2025-03-03 12:56:48', '/');
INSERT INTO `site_ziyaretleri` VALUES ('320', '176.234.135.50', '2025-03-03 12:56:56', '/');
INSERT INTO `site_ziyaretleri` VALUES ('321', '176.234.135.50', '2025-03-03 12:56:57', '/');
INSERT INTO `site_ziyaretleri` VALUES ('322', '176.234.135.50', '2025-03-03 12:57:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('323', '176.234.135.50', '2025-03-03 13:00:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('324', '176.234.135.50', '2025-03-03 13:00:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('325', '176.234.135.50', '2025-03-03 13:00:20', '/');
INSERT INTO `site_ziyaretleri` VALUES ('326', '176.234.135.50', '2025-03-03 13:00:21', '/');
INSERT INTO `site_ziyaretleri` VALUES ('327', '176.234.135.50', '2025-03-03 13:02:09', '/');
INSERT INTO `site_ziyaretleri` VALUES ('328', '176.234.135.50', '2025-03-03 13:02:11', '/');
INSERT INTO `site_ziyaretleri` VALUES ('329', '176.234.135.50', '2025-03-03 13:02:22', '/');
INSERT INTO `site_ziyaretleri` VALUES ('330', '176.234.135.50', '2025-03-03 13:02:24', '/');
INSERT INTO `site_ziyaretleri` VALUES ('331', '176.234.135.50', '2025-03-03 13:02:25', '/');
INSERT INTO `site_ziyaretleri` VALUES ('332', '176.234.135.50', '2025-03-03 13:02:31', '/');
INSERT INTO `site_ziyaretleri` VALUES ('333', '176.234.135.50', '2025-03-03 13:02:34', '/');
INSERT INTO `site_ziyaretleri` VALUES ('334', '176.234.135.50', '2025-03-03 13:02:36', '/');
INSERT INTO `site_ziyaretleri` VALUES ('335', '176.234.135.50', '2025-03-03 13:02:39', '/');
INSERT INTO `site_ziyaretleri` VALUES ('336', '176.234.135.50', '2025-03-03 13:02:49', '/');
INSERT INTO `site_ziyaretleri` VALUES ('337', '176.234.135.50', '2025-03-03 13:02:51', '/');
INSERT INTO `site_ziyaretleri` VALUES ('338', '176.234.135.50', '2025-03-03 13:02:54', '/');
INSERT INTO `site_ziyaretleri` VALUES ('339', '176.234.135.50', '2025-03-03 13:03:05', '/');
INSERT INTO `site_ziyaretleri` VALUES ('340', '176.234.135.50', '2025-03-03 13:03:09', '/');
INSERT INTO `site_ziyaretleri` VALUES ('341', '176.234.135.50', '2025-03-03 13:03:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('342', '31.141.80.77', '2025-03-03 14:33:13', '/');
INSERT INTO `site_ziyaretleri` VALUES ('343', '31.141.80.77', '2025-03-03 14:34:16', '/');
INSERT INTO `site_ziyaretleri` VALUES ('344', '31.141.80.77', '2025-03-03 14:34:45', '/');
INSERT INTO `site_ziyaretleri` VALUES ('345', '31.141.80.77', '2025-03-03 14:37:44', '/');
INSERT INTO `site_ziyaretleri` VALUES ('346', '31.141.80.77', '2025-03-03 14:38:06', '/');
INSERT INTO `site_ziyaretleri` VALUES ('347', '31.141.80.77', '2025-03-03 14:38:20', '/');
INSERT INTO `site_ziyaretleri` VALUES ('348', '176.54.80.26', '2025-03-03 14:39:00', '/');
INSERT INTO `site_ziyaretleri` VALUES ('349', '176.54.80.26', '2025-03-03 15:56:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('350', '104.152.52.58', '2025-03-03 17:57:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('351', '176.227.29.61', '2025-03-03 20:32:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('352', '82.197.68.199', '2025-03-03 22:07:08', '/');
INSERT INTO `site_ziyaretleri` VALUES ('353', '82.197.68.199', '2025-03-03 22:07:11', '/');
INSERT INTO `site_ziyaretleri` VALUES ('354', '176.227.29.61', '2025-03-03 22:21:08', '/');
INSERT INTO `site_ziyaretleri` VALUES ('355', '85.96.177.26', '2025-03-03 22:21:29', '/');
INSERT INTO `site_ziyaretleri` VALUES ('356', '138.68.178.38', '2025-03-04 05:08:49', '/');
INSERT INTO `site_ziyaretleri` VALUES ('357', '138.68.178.38', '2025-03-04 05:08:49', '/');
INSERT INTO `site_ziyaretleri` VALUES ('358', '176.227.29.61', '2025-03-04 14:13:58', '/');
INSERT INTO `site_ziyaretleri` VALUES ('359', '176.227.29.61', '2025-03-04 14:14:07', '/');
INSERT INTO `site_ziyaretleri` VALUES ('360', '176.89.127.186', '2025-03-04 14:14:45', '/');
INSERT INTO `site_ziyaretleri` VALUES ('361', '91.84.87.137', '2025-03-04 15:15:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('362', '91.84.87.137', '2025-03-04 15:16:25', '/');
INSERT INTO `site_ziyaretleri` VALUES ('363', '151.135.61.103', '2025-03-04 15:25:26', '/');
INSERT INTO `site_ziyaretleri` VALUES ('364', '23.27.145.200', '2025-03-04 16:35:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('365', '23.27.145.202', '2025-03-04 16:36:25', '/');
INSERT INTO `site_ziyaretleri` VALUES ('366', '165.227.47.172', '2025-03-04 17:02:20', '/');
INSERT INTO `site_ziyaretleri` VALUES ('367', '165.227.47.172', '2025-03-04 17:02:21', '/');
INSERT INTO `site_ziyaretleri` VALUES ('368', '209.38.99.132', '2025-03-05 09:01:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('369', '209.38.99.132', '2025-03-05 09:01:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('370', '176.227.29.61', '2025-03-05 14:35:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('371', '176.227.29.61', '2025-03-05 19:55:11', '/');
INSERT INTO `site_ziyaretleri` VALUES ('372', '31.142.107.137', '2025-03-05 19:55:17', '/');
INSERT INTO `site_ziyaretleri` VALUES ('373', '176.227.29.61', '2025-03-05 19:55:24', '/');
INSERT INTO `site_ziyaretleri` VALUES ('374', '176.227.29.61', '2025-03-05 19:55:53', '/');
INSERT INTO `site_ziyaretleri` VALUES ('375', '3.140.190.124', '2025-03-05 20:25:12', '/');
INSERT INTO `site_ziyaretleri` VALUES ('376', '3.140.190.124', '2025-03-05 20:25:13', '/');
INSERT INTO `site_ziyaretleri` VALUES ('377', '5.47.210.209', '2025-03-05 23:47:54', '/');
INSERT INTO `site_ziyaretleri` VALUES ('378', '3.140.190.124', '2025-03-06 04:19:55', '/');
INSERT INTO `site_ziyaretleri` VALUES ('379', '159.65.144.201', '2025-03-06 17:23:26', '/');
INSERT INTO `site_ziyaretleri` VALUES ('380', '159.65.144.201', '2025-03-06 17:23:28', '/');
INSERT INTO `site_ziyaretleri` VALUES ('381', '91.84.87.137', '2025-03-07 15:40:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('382', '91.84.87.137', '2025-03-07 15:42:31', '/');
INSERT INTO `site_ziyaretleri` VALUES ('383', '23.27.145.30', '2025-03-07 16:57:31', '/');
INSERT INTO `site_ziyaretleri` VALUES ('384', '23.27.145.55', '2025-03-07 16:58:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('385', '188.58.102.90', '2025-03-08 16:44:47', '/');
INSERT INTO `site_ziyaretleri` VALUES ('386', '15.237.61.14', '2025-03-09 17:41:51', '/');
INSERT INTO `site_ziyaretleri` VALUES ('387', '176.33.65.9', '2025-03-09 22:51:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('388', '18.207.100.231', '2025-03-10 04:50:35', '/');
INSERT INTO `site_ziyaretleri` VALUES ('389', '44.202.113.198', '2025-03-10 04:50:35', '/');
INSERT INTO `site_ziyaretleri` VALUES ('390', '149.57.180.32', '2025-03-10 17:08:02', '/');
INSERT INTO `site_ziyaretleri` VALUES ('391', '23.27.145.215', '2025-03-10 17:10:07', '/');
INSERT INTO `site_ziyaretleri` VALUES ('392', '135.148.100.196', '2025-03-11 15:21:52', '/');
INSERT INTO `site_ziyaretleri` VALUES ('393', '44.202.113.198', '2025-03-11 21:22:29', '/');
INSERT INTO `site_ziyaretleri` VALUES ('394', '44.202.113.198', '2025-03-11 21:22:30', '/');
INSERT INTO `site_ziyaretleri` VALUES ('395', '110.172.98.2', '2025-03-12 21:50:55', '/');
INSERT INTO `site_ziyaretleri` VALUES ('396', '178.243.204.21', '2025-03-13 08:42:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('397', '176.33.71.165', '2025-03-13 21:48:51', '/');
INSERT INTO `site_ziyaretleri` VALUES ('398', '176.33.71.165', '2025-03-13 21:52:43', '/');
INSERT INTO `site_ziyaretleri` VALUES ('399', '176.33.71.165', '2025-03-13 21:58:47', '/');
INSERT INTO `site_ziyaretleri` VALUES ('400', '176.33.71.165', '2025-03-13 22:01:28', '/');
INSERT INTO `site_ziyaretleri` VALUES ('401', '176.33.71.165', '2025-03-13 22:01:33', '/');
INSERT INTO `site_ziyaretleri` VALUES ('402', '176.33.71.165', '2025-03-13 22:03:23', '/');
INSERT INTO `site_ziyaretleri` VALUES ('403', '176.33.71.165', '2025-03-13 22:08:20', '/');
INSERT INTO `site_ziyaretleri` VALUES ('404', '176.33.71.165', '2025-03-13 22:08:36', '/');
INSERT INTO `site_ziyaretleri` VALUES ('405', '176.33.71.165', '2025-03-13 22:10:27', '/');
INSERT INTO `site_ziyaretleri` VALUES ('406', '176.33.71.165', '2025-03-13 22:10:27', '/');
INSERT INTO `site_ziyaretleri` VALUES ('407', '176.33.71.165', '2025-03-13 22:11:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('408', '185.247.137.197', '2025-03-13 22:11:23', '/');
INSERT INTO `site_ziyaretleri` VALUES ('409', '176.33.71.165', '2025-03-13 22:13:07', '/');
INSERT INTO `site_ziyaretleri` VALUES ('410', '176.33.71.165', '2025-03-13 22:13:10', '/');
INSERT INTO `site_ziyaretleri` VALUES ('411', '176.33.71.165', '2025-03-13 22:16:02', '/');
INSERT INTO `site_ziyaretleri` VALUES ('412', '176.33.71.165', '2025-03-13 22:16:07', '/');
INSERT INTO `site_ziyaretleri` VALUES ('413', '176.33.71.165', '2025-03-13 22:18:44', '/');
INSERT INTO `site_ziyaretleri` VALUES ('414', '106.74.80.6', '2025-03-13 22:19:43', '/');
INSERT INTO `site_ziyaretleri` VALUES ('415', '106.74.80.6', '2025-03-13 22:19:44', '/');
INSERT INTO `site_ziyaretleri` VALUES ('416', '106.74.80.6', '2025-03-13 22:19:44', '/');
INSERT INTO `site_ziyaretleri` VALUES ('417', '106.74.80.6', '2025-03-13 22:19:45', '/');
INSERT INTO `site_ziyaretleri` VALUES ('418', '176.33.71.165', '2025-03-13 22:20:00', '/');
INSERT INTO `site_ziyaretleri` VALUES ('419', '176.33.71.165', '2025-03-13 22:21:41', '/');
INSERT INTO `site_ziyaretleri` VALUES ('420', '176.33.71.165', '2025-03-13 22:22:02', '/');
INSERT INTO `site_ziyaretleri` VALUES ('421', '176.33.71.165', '2025-03-13 22:23:16', '/');
INSERT INTO `site_ziyaretleri` VALUES ('422', '176.33.71.165', '2025-03-13 22:23:32', '/');
INSERT INTO `site_ziyaretleri` VALUES ('423', '176.33.71.165', '2025-03-13 22:24:11', '/');
INSERT INTO `site_ziyaretleri` VALUES ('424', '176.33.71.165', '2025-03-13 22:25:06', '/');
INSERT INTO `site_ziyaretleri` VALUES ('425', '176.33.71.165', '2025-03-13 22:25:24', '/');
INSERT INTO `site_ziyaretleri` VALUES ('426', '176.33.71.165', '2025-03-13 22:26:31', '/');
INSERT INTO `site_ziyaretleri` VALUES ('427', '176.33.71.165', '2025-03-13 22:28:15', '/');
INSERT INTO `site_ziyaretleri` VALUES ('428', '176.33.71.165', '2025-03-13 22:29:29', '/');
INSERT INTO `site_ziyaretleri` VALUES ('429', '176.33.71.165', '2025-03-13 22:29:46', '/');
INSERT INTO `site_ziyaretleri` VALUES ('430', '176.33.71.165', '2025-03-13 22:30:53', '/');
INSERT INTO `site_ziyaretleri` VALUES ('431', '176.33.71.165', '2025-03-13 22:32:34', '/');
INSERT INTO `site_ziyaretleri` VALUES ('432', '176.33.71.165', '2025-03-13 22:34:02', '/');
INSERT INTO `site_ziyaretleri` VALUES ('433', '176.33.71.165', '2025-03-13 22:36:14', '/');
INSERT INTO `site_ziyaretleri` VALUES ('434', '176.33.71.165', '2025-03-13 22:36:37', '/');
INSERT INTO `site_ziyaretleri` VALUES ('435', '176.33.71.165', '2025-03-13 22:36:40', '/');
INSERT INTO `site_ziyaretleri` VALUES ('436', '176.33.71.165', '2025-03-13 22:37:31', '/');
INSERT INTO `site_ziyaretleri` VALUES ('437', '176.33.71.165', '2025-03-13 22:37:47', '/');
INSERT INTO `site_ziyaretleri` VALUES ('438', '176.33.71.165', '2025-03-13 22:37:58', '/');
INSERT INTO `site_ziyaretleri` VALUES ('439', '176.33.71.165', '2025-03-13 22:38:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('440', '176.33.71.165', '2025-03-13 22:38:21', '/');
INSERT INTO `site_ziyaretleri` VALUES ('441', '178.243.204.21', '2025-03-13 22:38:39', '/');
INSERT INTO `site_ziyaretleri` VALUES ('442', '178.243.204.21', '2025-03-13 22:40:38', '/');
INSERT INTO `site_ziyaretleri` VALUES ('443', '178.243.204.21', '2025-03-13 22:40:40', '/');
INSERT INTO `site_ziyaretleri` VALUES ('444', '178.243.204.21', '2025-03-13 22:43:24', '/');
INSERT INTO `site_ziyaretleri` VALUES ('445', '178.243.204.21', '2025-03-13 22:43:29', '/');
INSERT INTO `site_ziyaretleri` VALUES ('446', '178.243.204.21', '2025-03-13 22:43:46', '/');
INSERT INTO `site_ziyaretleri` VALUES ('447', '176.33.71.165', '2025-03-13 22:45:27', '/');
INSERT INTO `site_ziyaretleri` VALUES ('448', '176.33.71.165', '2025-03-13 22:45:29', '/');
INSERT INTO `site_ziyaretleri` VALUES ('449', '176.33.71.165', '2025-03-13 22:45:44', '/');
INSERT INTO `site_ziyaretleri` VALUES ('450', '178.243.204.21', '2025-03-13 22:45:49', '/');
INSERT INTO `site_ziyaretleri` VALUES ('451', '176.33.71.165', '2025-03-13 22:47:00', '/');
INSERT INTO `site_ziyaretleri` VALUES ('452', '176.33.71.165', '2025-03-13 22:47:07', '/');
INSERT INTO `site_ziyaretleri` VALUES ('453', '176.33.71.165', '2025-03-13 22:47:54', '/');
INSERT INTO `site_ziyaretleri` VALUES ('454', '178.243.204.21', '2025-03-13 22:48:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('455', '178.243.204.21', '2025-03-13 22:48:11', '/');
INSERT INTO `site_ziyaretleri` VALUES ('456', '178.243.204.21', '2025-03-13 22:48:27', '/');
INSERT INTO `site_ziyaretleri` VALUES ('457', '176.33.71.165', '2025-03-13 22:49:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('458', '178.243.204.21', '2025-03-13 22:49:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('459', '178.243.204.21', '2025-03-13 22:49:16', '/');
INSERT INTO `site_ziyaretleri` VALUES ('460', '176.33.71.165', '2025-03-13 22:50:59', '/');
INSERT INTO `site_ziyaretleri` VALUES ('461', '176.33.71.165', '2025-03-13 22:51:08', '/');
INSERT INTO `site_ziyaretleri` VALUES ('462', '176.33.71.165', '2025-03-13 22:51:13', '/');
INSERT INTO `site_ziyaretleri` VALUES ('463', '178.243.204.21', '2025-03-13 22:51:23', '/');
INSERT INTO `site_ziyaretleri` VALUES ('464', '178.243.204.21', '2025-03-13 22:51:39', '/');
INSERT INTO `site_ziyaretleri` VALUES ('465', '176.33.71.165', '2025-03-13 22:52:13', '/');
INSERT INTO `site_ziyaretleri` VALUES ('466', '176.33.71.165', '2025-03-13 22:52:25', '/');
INSERT INTO `site_ziyaretleri` VALUES ('467', '176.33.71.165', '2025-03-13 22:52:31', '/');
INSERT INTO `site_ziyaretleri` VALUES ('468', '176.33.71.165', '2025-03-13 22:52:57', '/');
INSERT INTO `site_ziyaretleri` VALUES ('469', '176.33.71.165', '2025-03-13 22:53:12', '/');
INSERT INTO `site_ziyaretleri` VALUES ('470', '176.33.71.165', '2025-03-13 22:59:08', '/');
INSERT INTO `site_ziyaretleri` VALUES ('471', '176.33.71.165', '2025-03-13 23:00:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('472', '176.33.71.165', '2025-03-13 23:00:06', '/');
INSERT INTO `site_ziyaretleri` VALUES ('473', '176.33.71.165', '2025-03-13 23:01:55', '/');
INSERT INTO `site_ziyaretleri` VALUES ('474', '176.33.71.165', '2025-03-13 23:03:16', '/');
INSERT INTO `site_ziyaretleri` VALUES ('475', '176.33.71.165', '2025-03-13 23:03:23', '/');
INSERT INTO `site_ziyaretleri` VALUES ('476', '176.33.71.165', '2025-03-13 23:09:30', '/');
INSERT INTO `site_ziyaretleri` VALUES ('477', '176.33.71.165', '2025-03-13 23:10:43', '/');
INSERT INTO `site_ziyaretleri` VALUES ('478', '176.33.71.165', '2025-03-13 23:11:06', '/');
INSERT INTO `site_ziyaretleri` VALUES ('479', '176.33.71.165', '2025-03-13 23:11:12', '/');
INSERT INTO `site_ziyaretleri` VALUES ('480', '176.33.71.165', '2025-03-13 23:11:17', '/');
INSERT INTO `site_ziyaretleri` VALUES ('481', '176.33.71.165', '2025-03-13 23:12:05', '/');
INSERT INTO `site_ziyaretleri` VALUES ('482', '176.33.71.165', '2025-03-13 23:14:30', '/');
INSERT INTO `site_ziyaretleri` VALUES ('483', '176.33.71.165', '2025-03-13 23:14:41', '/');
INSERT INTO `site_ziyaretleri` VALUES ('484', '178.243.204.21', '2025-03-13 23:15:26', '/');
INSERT INTO `site_ziyaretleri` VALUES ('485', '178.243.204.21', '2025-03-13 23:15:32', '/');
INSERT INTO `site_ziyaretleri` VALUES ('486', '176.33.71.165', '2025-03-13 23:15:39', '/');
INSERT INTO `site_ziyaretleri` VALUES ('487', '178.243.204.21', '2025-03-13 23:15:41', '/');
INSERT INTO `site_ziyaretleri` VALUES ('488', '178.243.204.21', '2025-03-13 23:15:44', '/');
INSERT INTO `site_ziyaretleri` VALUES ('489', '178.243.204.21', '2025-03-13 23:16:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('490', '178.243.204.21', '2025-03-13 23:16:11', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('491', '74.125.208.5', '2025-03-13 23:16:12', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('492', '66.102.9.230', '2025-03-13 23:16:13', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('493', '74.125.213.36', '2025-03-13 23:16:13', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('494', '178.243.204.21', '2025-03-13 23:16:15', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('495', '178.243.204.21', '2025-03-13 23:16:30', '/');
INSERT INTO `site_ziyaretleri` VALUES ('496', '176.33.71.165', '2025-03-13 23:16:46', '/');
INSERT INTO `site_ziyaretleri` VALUES ('497', '176.33.71.165', '2025-03-13 23:16:53', '/');
INSERT INTO `site_ziyaretleri` VALUES ('498', '176.33.71.165', '2025-03-13 23:17:00', '/');
INSERT INTO `site_ziyaretleri` VALUES ('499', '176.33.71.165', '2025-03-13 23:18:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('500', '176.33.71.165', '2025-03-13 23:18:54', '/');
INSERT INTO `site_ziyaretleri` VALUES ('501', '176.33.71.165', '2025-03-13 23:18:58', '/');
INSERT INTO `site_ziyaretleri` VALUES ('502', '176.33.71.165', '2025-03-13 23:19:08', '/');
INSERT INTO `site_ziyaretleri` VALUES ('503', '176.33.71.165', '2025-03-13 23:19:13', '/');
INSERT INTO `site_ziyaretleri` VALUES ('504', '176.33.71.165', '2025-03-13 23:20:13', '/');
INSERT INTO `site_ziyaretleri` VALUES ('505', '176.33.71.165', '2025-03-13 23:20:16', '/');
INSERT INTO `site_ziyaretleri` VALUES ('506', '176.33.71.165', '2025-03-13 23:20:22', '/');
INSERT INTO `site_ziyaretleri` VALUES ('507', '176.33.71.165', '2025-03-13 23:20:26', '/');
INSERT INTO `site_ziyaretleri` VALUES ('508', '176.33.71.165', '2025-03-13 23:20:51', '/');
INSERT INTO `site_ziyaretleri` VALUES ('509', '176.33.71.165', '2025-03-13 23:20:53', '/');
INSERT INTO `site_ziyaretleri` VALUES ('510', '176.33.71.165', '2025-03-13 23:20:55', '/');
INSERT INTO `site_ziyaretleri` VALUES ('511', '176.33.71.165', '2025-03-13 23:20:58', '/');
INSERT INTO `site_ziyaretleri` VALUES ('512', '176.33.71.165', '2025-03-13 23:21:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('513', '176.33.71.165', '2025-03-13 23:21:04', '/');
INSERT INTO `site_ziyaretleri` VALUES ('514', '176.33.71.165', '2025-03-13 23:22:30', '/');
INSERT INTO `site_ziyaretleri` VALUES ('515', '176.33.71.165', '2025-03-13 23:22:37', '/');
INSERT INTO `site_ziyaretleri` VALUES ('516', '176.33.71.165', '2025-03-13 23:24:19', '/');
INSERT INTO `site_ziyaretleri` VALUES ('517', '178.243.204.21', '2025-03-13 23:25:00', '/');
INSERT INTO `site_ziyaretleri` VALUES ('518', '178.243.204.21', '2025-03-13 23:25:18', '/');
INSERT INTO `site_ziyaretleri` VALUES ('519', '178.243.204.21', '2025-03-13 23:25:24', '/');
INSERT INTO `site_ziyaretleri` VALUES ('520', '176.33.71.165', '2025-03-13 23:25:32', '/');
INSERT INTO `site_ziyaretleri` VALUES ('521', '176.33.71.165', '2025-03-13 23:25:34', '/');
INSERT INTO `site_ziyaretleri` VALUES ('522', '178.247.132.158', '2025-03-13 23:25:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('523', '176.33.71.165', '2025-03-13 23:26:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('524', '178.247.132.158', '2025-03-13 23:26:14', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('525', '178.247.132.158', '2025-03-13 23:26:17', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('526', '176.33.71.165', '2025-03-13 23:26:35', '/');
INSERT INTO `site_ziyaretleri` VALUES ('527', '178.247.132.158', '2025-03-13 23:26:38', '/index.php');
INSERT INTO `site_ziyaretleri` VALUES ('528', '178.247.132.158', '2025-03-13 23:26:50', '/');
INSERT INTO `site_ziyaretleri` VALUES ('529', '178.247.132.158', '2025-03-13 23:27:02', '/');
INSERT INTO `site_ziyaretleri` VALUES ('530', '176.33.71.165', '2025-03-13 23:27:03', '/');
INSERT INTO `site_ziyaretleri` VALUES ('531', '176.33.71.165', '2025-03-13 23:27:07', '/');
INSERT INTO `site_ziyaretleri` VALUES ('532', '178.247.132.158', '2025-03-13 23:27:12', '/');
INSERT INTO `site_ziyaretleri` VALUES ('533', '151.135.29.169', '2025-03-13 23:27:45', '/');
INSERT INTO `site_ziyaretleri` VALUES ('534', '178.247.132.158', '2025-03-13 23:27:57', '/');
INSERT INTO `site_ziyaretleri` VALUES ('535', '151.135.29.169', '2025-03-13 23:28:08', '/');
INSERT INTO `site_ziyaretleri` VALUES ('536', '178.247.132.158', '2025-03-13 23:28:37', '/');
INSERT INTO `site_ziyaretleri` VALUES ('537', '176.33.71.165', '2025-03-13 23:28:47', '/');
INSERT INTO `site_ziyaretleri` VALUES ('538', '74.125.208.14', '2025-03-13 23:28:56', '/');
INSERT INTO `site_ziyaretleri` VALUES ('539', '74.125.208.14', '2025-03-13 23:28:57', '/');
INSERT INTO `site_ziyaretleri` VALUES ('540', '66.249.93.164', '2025-03-13 23:29:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('541', '74.125.208.5', '2025-03-13 23:29:01', '/');
INSERT INTO `site_ziyaretleri` VALUES ('542', '66.249.93.164', '2025-03-13 23:29:05', '/');
INSERT INTO `site_ziyaretleri` VALUES ('543', '74.125.208.4', '2025-03-13 23:29:06', '/');
INSERT INTO `site_ziyaretleri` VALUES ('544', '50.19.167.206', '2025-03-13 23:39:20', '/');

-- Tablo yapısı: urun_degerlendirmeleri
DROP TABLE IF EXISTS `urun_degerlendirmeleri`;
CREATE TABLE `urun_degerlendirmeleri` (
  `id` int NOT NULL AUTO_INCREMENT,
  `urun_id` int NOT NULL,
  `kullanici_ip` varchar(45) NOT NULL,
  `degerlendirme_tipi` enum('like','dislike') NOT NULL,
  `tarih` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `urun_kullanici_unique` (`urun_id`,`kullanici_ip`),
  CONSTRAINT `urun_degerlendirmeleri_ibfk_1` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Tablo yapısı: urunler
DROP TABLE IF EXISTS `urunler`;
CREATE TABLE `urunler` (
  `id` int NOT NULL AUTO_INCREMENT,
  `kategori_id` int NOT NULL,
  `urun_adi` varchar(100) NOT NULL,
  `fiyat` decimal(10,2) NOT NULL,
  `aciklama` text,
  `resim` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `stok_durumu` tinyint(1) DEFAULT '1' COMMENT '1: Stokta var, 0: Stokta yok',
  `populer` tinyint(1) DEFAULT '0' COMMENT '1: Popüler ürün, 0: Normal ürün',
  `begeni_sayisi` int DEFAULT '0',
  `begenmeme_sayisi` int DEFAULT '0',
  `gluten` tinyint(1) DEFAULT '0',
  `sut` tinyint(1) DEFAULT '0',
  `soya` tinyint(1) DEFAULT '0',
  `yumurta` tinyint(1) DEFAULT '0',
  `balik` tinyint(1) DEFAULT '0',
  `yerfistigi` tinyint(1) DEFAULT '0',
  `kabuklular` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `kategori_id` (`kategori_id`),
  CONSTRAINT `urunler_ibfk_1` FOREIGN KEY (`kategori_id`) REFERENCES `kategoriler` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- Tablo verisi: urunler
INSERT INTO `urunler` VALUES ('12', '13', 'Serpme Köy Kahvaltısı', '400.00', 'Kavurmalı yumurta, patatesli yumurta, menemen, ciğer kavurması, yöresel nohut haşlaması, simit aşı, soslu sosis, sigara böreği, muska böreği, paçanga böreği, patates kızartması, gözleme, çöp şişte hellim ve sucuk, söğüş tabağı ( domates salatalık ve yeşillik )', '67d339feb47b0.webp', '2025-03-13 22:21:37', '1', '1', '0', '0', '1', '1', '1', '1', '0', '0', '0');
INSERT INTO `urunler` VALUES ('13', '13', 'Karışık Tost', '100.00', 'Karışık (Kaşarlı, Kavurmalı, Sucuklu) Tost', '67d339f33df63.webp', '2025-03-13 22:23:13', '1', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('14', '13', 'Sucuklu Tost', '75.00', 'Sucuklu, kaşarlı Tost.', '67d339ec50e23.webp', '2025-03-13 22:24:05', '1', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('15', '13', 'Kahvaltı Tabağı', '150.00', '1 Kişilik Doyurucu Kahvaltı Tabağı', '67d339e166847.webp', '2025-03-13 22:25:04', '1', '0', '0', '0', '1', '1', '0', '1', '0', '0', '0');
INSERT INTO `urunler` VALUES ('16', '14', 'Sezar Salata', '100.00', 'Akdeniz yeşillikleri, kroton ekmek, tavuk bonfile, al biber, sezar sos ile servis edilir.

', '67d339dc41193.webp', '2025-03-13 22:26:03', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('17', '14', 'Hellim Salata', '100.00', 'Akdeniz yeşillikleri, mısır, çeri domates, al biber, zeytin ve hellim peyniri

', '67d339d5e687b.webp', '2025-03-13 22:26:29', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('18', '14', 'Mevsim Salata', '100.00', 'Göbek marul, rendelenmiş havuç, beyaz peynir, mısır, domates, al biber, zeytinyağı

', '67d339d0f0ac0.webp', '2025-03-13 22:26:58', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('19', '15', 'Cheese Burger', '180.00', 'Kuzu eti, kaşar peyniri, marul, domates, kornişon turşu, rus salatası, cips, yeşillikle servis edilir..', '67d339cbdd344.webp', '2025-03-13 22:27:44', '1', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('20', '15', 'New York Burger', '200.00', 'Kuzu eti, karamelize soğan, mantar, marul, salatalık turşusu, domotes, rus salatası, soğan halkası, yeşillikle servis edilir..

', '67d339b0496d5.webp', '2025-03-13 22:28:12', '1', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('21', '16', 'KUZU KAFES', '400.00', '', '67d339a74e26c.webp', '2025-03-13 22:28:55', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('22', '16', 'DALLAS STEAK', '400.00', '', '67d3399dcb6d4.webp', '2025-03-13 22:29:10', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('23', '16', 'DANA LOKUM', '500.00', '', '67d339924d603.webp', '2025-03-13 22:29:28', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('24', '17', 'Et Kuşbaşı Dürüm', '200.00', 'Et Kuşbaşı Dürüm', '67d3398c15884.webp', '2025-03-13 22:32:13', '1', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('25', '17', 'Kıyma Dürüm', '200.00', 'Kıyma Dürüm', '67d3398543e80.webp', '2025-03-13 22:32:33', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('27', '18', 'CHICKEN SCHNİTZEL', '150.00', 'Panelenmiş tavuk bonfile, pilav, cips, rus salatası ve Akdeniz yeşillikleri', '67d3397803599.webp', '2025-03-13 22:33:53', '1', '1', '0', '0', '1', '1', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('28', '19', 'Tavuklu Pizza', '100.00', 'Tavuk, domates, biber, kaşar ile servis edilir

', '67d33969a2b26.webp', '2025-03-13 22:34:45', '1', '1', '0', '0', '1', '0', '0', '1', '0', '0', '0');
INSERT INTO `urunler` VALUES ('29', '19', 'Vejeteryan Pizza', '150.00', 'Kaşar, mantar, domates, zeytin, biber, mısır ile servis edilir

', '67d3395f7735c.webp', '2025-03-13 22:35:33', '1', '1', '0', '0', '1', '0', '0', '0', '0', '0', '0');
INSERT INTO `urunler` VALUES ('30', '20', 'Kıymalı Pide', '100.00', 'Kıyma, domates, biber ile servis edilir

', '67d3393250991.webp', '2025-03-13 22:36:10', '1', '1', '0', '0', '1', '1', '1', '1', '1', '1', '1');

SET FOREIGN_KEY_CHECKS=1;
