<?php
session_start();
require_once 'auth.php'; // Merkezi yetki kontrolü
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Ayarları Güncelle
if(isset($_POST['ayarlar_guncelle'])) {
    $isletme_adi = $_POST['isletme_adi'];
    $adres = $_POST['adres'];
    $telefon = $_POST['telefon'];
    $email = $_POST['email'];
    $haftaici_saatler = $_POST['haftaici_saatler'];
    $haftasonu_saatler = $_POST['haftasonu_saatler'];
    $facebook = $_POST['facebook'];
    $facebook_kullanici = $_POST['facebook_kullanici'];
    $instagram = $_POST['instagram'];
    $instagram_kullanici = $_POST['instagram_kullanici'];
    $twitter = $_POST['twitter'];
    $twitter_kullanici = $_POST['twitter_kullanici'];
    $whatsapp = $_POST['whatsapp'];
    $magaza_url = $_POST['magaza_url'];
    $copyright = $_POST['copyright'];
    $wifi_ag_adi = $_POST['wifi_ag_adi'];
    $wifi_sifre = $_POST['wifi_sifre'];
    $wifi_guvenlik = $_POST['wifi_guvenlik'];
    $header_bg_color = $_POST['header_bg_color'];
    $bottom_bar_bg_color = $_POST['bottom_bar_bg_color'];
    $feedback_circle_color = $_POST['feedback_circle_color'];
    $sidebar_bg_color = $_POST['sidebar_bg_color'];
    $header_icon_color = $_POST['header_icon_color'];
    $bottom_bar_icon_color = $_POST['bottom_bar_icon_color'];
    
    // Logo yükleme
    if(isset($_FILES['logo']) && $_FILES['logo']['error'] == 0) {
        $izin_verilen_uzantilar = array('jpg', 'jpeg', 'png');
        $dosya_uzantisi = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
        
        if(in_array($dosya_uzantisi, $izin_verilen_uzantilar)) {
            // Eski logoyu sil
            $stmt = $conn->query("SELECT logo FROM ayarlar WHERE id = 1");
            $eski_ayarlar = $stmt->fetch(PDO::FETCH_ASSOC);
            if($eski_ayarlar && $eski_ayarlar['logo']) {
                $eski_logo = '../uploads/' . $eski_ayarlar['logo'];
                if(file_exists($eski_logo)) {
                    unlink($eski_logo);
                }
            }
            
            // Yeni logoyu yükle
            $yeni_isim = 'logo.' . $dosya_uzantisi;
            move_uploaded_file($_FILES['logo']['tmp_name'], '../uploads/' . $yeni_isim);
            
            // Veritabanında logo adını güncelle
            $logo = $yeni_isim;
        }
    }
    
    // Mağaza fotoğrafı yükleme
    if(isset($_FILES['magaza_foto']) && $_FILES['magaza_foto']['error'] == 0) {
        $izin_verilen_uzantilar = array('jpg', 'jpeg', 'png');
        $dosya_uzantisi = strtolower(pathinfo($_FILES['magaza_foto']['name'], PATHINFO_EXTENSION));
        
        if(in_array($dosya_uzantisi, $izin_verilen_uzantilar)) {
            // Eski fotoğrafı sil
            $stmt = $conn->query("SELECT magaza_foto FROM ayarlar WHERE id = 1");
            $eski_ayarlar = $stmt->fetch(PDO::FETCH_ASSOC);
            if($eski_ayarlar && $eski_ayarlar['magaza_foto']) {
                $eski_foto = '../uploads/' . $eski_ayarlar['magaza_foto'];
                if(file_exists($eski_foto)) {
                    unlink($eski_foto);
                }
            }
            
            // Yeni fotoğrafı yükle
            $yeni_isim = 'magaza_foto_' . time() . '.' . $dosya_uzantisi;
            move_uploaded_file($_FILES['magaza_foto']['tmp_name'], '../uploads/' . $yeni_isim);
            
            // Veritabanında fotoğraf adını güncelle
            $magaza_foto = $yeni_isim;
        }
    }
    
    // Veritabanını güncelle
    $stmt = $conn->prepare("SELECT COUNT(*) FROM ayarlar");
    $stmt->execute();
    $ayar_var_mi = $stmt->fetchColumn();
    
    if($ayar_var_mi) {
        $sql = "UPDATE ayarlar SET 
                isletme_adi = ?, 
                adres = ?, 
                telefon = ?, 
                email = ?, 
                haftaici_saatler = ?, 
                haftasonu_saatler = ?, 
                facebook = ?, 
                facebook_kullanici = ?,
                instagram = ?, 
                instagram_kullanici = ?,
                twitter = ?, 
                twitter_kullanici = ?,
                whatsapp = ?,
                magaza_url = ?,
                copyright = ?,
                wifi_ag_adi = ?,
                wifi_sifre = ?,
                wifi_guvenlik = ?,
                header_bg_color = ?,
                bottom_bar_bg_color = ?,
                feedback_circle_color = ?,
                sidebar_bg_color = ?,
                header_icon_color = ?,
                bottom_bar_icon_color = ?";
                
        $params = [
            $isletme_adi, $adres, $telefon, $email, 
            $haftaici_saatler, $haftasonu_saatler,
            $facebook, $facebook_kullanici,
            $instagram, $instagram_kullanici,
            $twitter, $twitter_kullanici,
            $whatsapp, $magaza_url,
            $copyright,
            $wifi_ag_adi,
            $wifi_sifre,
            $wifi_guvenlik,
            $header_bg_color,
            $bottom_bar_bg_color,
            $feedback_circle_color,
            $sidebar_bg_color,
            $header_icon_color,
            $bottom_bar_icon_color
        ];
        
        if(isset($logo)) {
            $sql .= ", logo = ?";
            $params[] = $logo;
        }
        
        if(isset($magaza_foto)) {
            $sql .= ", magaza_foto = ?";
            $params[] = $magaza_foto;
        }
        
        $sql .= " WHERE id = 1";
    } else {
        $sql = "INSERT INTO ayarlar (
                isletme_adi, adres, telefon, email, 
                haftaici_saatler, haftasonu_saatler,
                facebook, facebook_kullanici,
                instagram, instagram_kullanici,
                twitter, twitter_kullanici,
                whatsapp,
                magaza_url,
                copyright,
                wifi_ag_adi,
                wifi_sifre,
                wifi_guvenlik,
                header_bg_color,
                bottom_bar_bg_color,
                feedback_circle_color,
                sidebar_bg_color,
                header_icon_color,
                bottom_bar_icon_color" . 
                (isset($logo) ? ", logo" : "") . 
                (isset($magaza_foto) ? ", magaza_foto" : "") . 
                ") VALUES (?" . str_repeat(",?", 21) . (isset($logo) ? ",?" : "") . (isset($magaza_foto) ? ",?" : "") . ")";
        $params = [
            $isletme_adi, $adres, $telefon, $email, 
            $haftaici_saatler, $haftasonu_saatler,
            $facebook, $facebook_kullanici,
            $instagram, $instagram_kullanici,
            $twitter, $twitter_kullanici,
            $whatsapp,
            $magaza_url,
            $copyright,
            $wifi_ag_adi,
            $wifi_sifre,
            $wifi_guvenlik,
            $header_bg_color,
            $bottom_bar_bg_color,
            $feedback_circle_color,
            $sidebar_bg_color,
            $header_icon_color,
            $bottom_bar_icon_color
        ];
        if(isset($logo)) {
            $params[] = $logo;
        }
        if(isset($magaza_foto)) {
            $params[] = $magaza_foto;
        }
    }
    
    try {
        $stmt = $conn->prepare($sql);
        if($stmt->execute($params)) {
            header("Location: ayarlar.php?mesaj=guncellendi");
        } else {
            $error = $stmt->errorInfo();
            error_log("SQL Hata: " . print_r($error, true));
            header("Location: ayarlar.php?mesaj=hata&kod=" . $error[1]);
        }
    } catch(PDOException $e) {
        error_log("Ayarlar güncelleme hatası: " . $e->getMessage());
        header("Location: ayarlar.php?mesaj=hata&hata=" . urlencode($e->getMessage()));
    }
    exit;
}

// SEO ayarlarını güncelle
if(isset($_POST['seo_ayarlarini_guncelle'])) {
    $site_basligi = $_POST['site_basligi'];
    $site_aciklamasi = $_POST['site_aciklamasi'];
    $site_etiketleri = $_POST['site_etiketleri'];

    $stmt = $conn->prepare("UPDATE ayarlar SET site_basligi = ?, site_aciklamasi = ?, site_etiketleri = ? WHERE id = 1");
    $stmt->execute([$site_basligi, $site_aciklamasi, $site_etiketleri]);

    header("Location: ayarlar.php?mesaj=guncellendi");
}

// Favicon yükleme
if(isset($_FILES['favicon']) && $_FILES['favicon']['error'] == 0) {
    $favicon = $_FILES['favicon'];
    $favicon_uzanti = strtolower(pathinfo($favicon['name'], PATHINFO_EXTENSION));
    $izin_verilen_uzantilar = array('ico', 'png', 'jpg', 'jpeg');

    if(in_array($favicon_uzanti, $izin_verilen_uzantilar)) {
        $yeni_favicon = 'favicon.' . $favicon_uzanti;
        move_uploaded_file($favicon['tmp_name'], '../uploads/' . $yeni_favicon);

        $stmt = $conn->prepare("UPDATE ayarlar SET favicon = ? WHERE id = 1");
        $stmt->execute([$yeni_favicon]);

        header("Location: ayarlar.php?mesaj=guncellendi");
    } else {
        $error_message = "Geçersiz dosya uzantısı. Lütfen .ico, .png, .jpg veya .jpeg uzantılı bir dosya yükleyin.";
    }
}

// Mevcut ayarları al
$stmt = $conn->query("SELECT * FROM ayarlar WHERE id = 1");
$ayarlar = $stmt->fetch(PDO::FETCH_ASSOC);

// Debug için SQL ve parametreleri yazdır
if(isset($_POST['ayarlar_guncelle'])) {
    error_log("SQL: " . $sql);
    error_log("Parametreler: " . print_r($params, true));
}

// Hata mesajlarını göster
if(isset($_GET['mesaj'])) {
    if($_GET['mesaj'] == 'hata') {
        $hata_mesaji = "Ayarlar güncellenirken bir hata oluştu.";
        if(isset($_GET['hata'])) {
            $hata_mesaji .= "<br>Hata detayı: " . htmlspecialchars($_GET['hata']);
        }
        if(isset($_GET['kod'])) {
            $hata_mesaji .= "<br>Hata kodu: " . htmlspecialchars($_GET['kod']);
        }
        echo '<div class="alert alert-danger">' . $hata_mesaji . '</div>';
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ayarlar - QR Menü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            padding-top: 20px;
            z-index: 1000;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            display: block;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .content {
            padding: 20px;
        }
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                width: 250px;
                height: 100%;
                transition: left 0.3s ease;
                z-index: 1000;
            }
            .sidebar.show {
                left: 0;
            }
            #sidebarClose {
                display: inline; /* Mobilde göster */
            }
        }
        @media (min-width: 769px) {
            #sidebarClose {
                display: none; /* Masaüstünde gizle */
            }
        }
        .current-logo {
            max-width: 200px;
            max-height: 200px;
            object-fit: contain;
            margin-bottom: 10px;
        }
        .card-header {
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .card-header:hover {
            background-color: #f8f9fa;
        }
        .card-header .fa-chevron-down {
            transition: transform 0.3s ease;
        }
        .card-header[aria-expanded="true"] .fa-chevron-down {
            transform: rotate(180deg);
        }
        .card-header[role="button"]:hover {
            background-color: #f8f9fa;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <button class="btn btn-primary d-md-none" id="sidebarToggle">Menüyü Göster</button>
        <div class="row">
            <div class="col-md-2 sidebar" id="sidebar">
                <h3 class="text-white text-center mb-4">QR Menü Admin <span id="sidebarClose" style="cursor: pointer; color: white;">&times;</span></h3>
                <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                <a href="kategoriler.php"><i class="fas fa-list"></i> Kategoriler</a>
                <a href="urunler.php"><i class="fas fa-utensils"></i> Ürünler</a>
                <a href="sikayet.php"><i class="fas fa-comment-alt"></i> Şikayetler</a>
                <a href="qr.php"><i class="fas fa-qrcode"></i> QR Kodlar</a>
                <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </div>
            
            <div class="col-md-10 content" id="contentArea">
                <h2 class="mb-4">Ayarlar</h2>
                
                <!-- SEO Ayarları -->
                <div class="card mb-4">
                    <div class="card-header" data-bs-toggle="collapse" data-bs-target="#seoSettings" aria-expanded="false" aria-controls="seoSettings">
                        <h5 class="mb-0">SEO Ayarları</h5>
                    </div>
                    <div id="seoSettings" class="collapse">
                        <div class="card-body">
                            <form method="POST" action="">
                                <div class="mb-3">
                                    <label for="site_basligi" class="form-label">Site Başlığı</label>
                                    <input type="text" class="form-control" id="site_basligi" name="site_basligi" value="<?php echo isset($ayarlar['site_basligi']) ? $ayarlar['site_basligi'] : ''; ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="site_aciklamasi" class="form-label">Site Açıklaması</label>
                                    <textarea class="form-control" id="site_aciklamasi" name="site_aciklamasi" rows="3" required><?php echo isset($ayarlar['site_aciklamasi']) ? $ayarlar['site_aciklamasi'] : ''; ?></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="site_etiketleri" class="form-label">Site Etiketleri (Virgülle ayırın)</label>
                                    <input type="text" class="form-control" id="site_etiketleri" name="site_etiketleri" value="<?php echo isset($ayarlar['site_etiketleri']) ? $ayarlar['site_etiketleri'] : ''; ?>" required>
                                </div>
                                <button type="submit" name="seo_ayarlarini_guncelle" class="btn btn-primary">Güncelle</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Favicon Yükleme -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Favicon Yükle</h5>
                    </div>
                    <div class="card-body">
                        <form method="POST" action="" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="favicon" class="form-label">Favicon Yükle (ico, png, jpg)</label>
                                <input type="file" class="form-control" id="favicon" name="favicon" accept=".ico,.png,.jpg,.jpeg" required>
                            </div>
                            <button type="submit" class="btn btn-primary">Favicon Yükle</button>
                        </form>
                    </div>
                </div>

                <?php if(isset($_GET['mesaj']) && $_GET['mesaj'] == 'guncellendi'): ?>
                    <div class="alert alert-success">Ayarlar başarıyla güncellendi.</div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="" enctype="multipart/form-data">
                            <!-- İşletme Bilgileri -->
                            <div class="card mb-4">
                                <div class="card-header" role="button" data-bs-toggle="collapse" data-bs-target="#isletmeBilgileri" aria-expanded="false">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-store me-2"></i>
                                            İşletme Bilgileri
                                        </h5>
                                        <i class="fas fa-chevron-down"></i>
                                    </div>
                                </div>
                                <div class="collapse" id="isletmeBilgileri">
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="isletme_adi" class="form-label">İşletme Adı</label>
                                            <input type="text" class="form-control" id="isletme_adi" name="isletme_adi" value="<?php echo $ayarlar['isletme_adi'] ?? ''; ?>" required>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="adres" class="form-label">Adres</label>
                                            <textarea class="form-control" id="adres" name="adres" rows="3" required><?php echo $ayarlar['adres'] ?? ''; ?></textarea>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="telefon" class="form-label">Telefon</label>
                                            <input type="text" class="form-control" id="telefon" name="telefon" value="<?php echo $ayarlar['telefon'] ?? ''; ?>" required>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="email" class="form-label">E-posta</label>
                                            <input type="email" class="form-control" id="email" name="email" value="<?php echo $ayarlar['email'] ?? ''; ?>" required>
                                        </div>

                                        <div class="mb-3">
                                            <label for="haftaici_saatler" class="form-label">Çalışma Saatleri</label>
                                            <input type="text" class="form-control" id="haftaici_saatler" name="haftaici_saatler" 
                                                   value="<?php echo $ayarlar['haftaici_saatler'] ?? ''; ?>" 
                                                   placeholder="Örn: 09:00 - 22:00">
                                        </div>

                                        <div class="mb-3">
                                            <label for="logo" class="form-label">Logo</label>
                                            <?php if(!empty($ayarlar['logo'])): ?>
                                                <div class="mb-2">
                                                    <img src="../uploads/<?php echo $ayarlar['logo']; ?>" alt="Mevcut Logo" class="current-logo">
                                                </div>
                                            <?php endif; ?>
                                            <input type="file" class="form-control" id="logo" name="logo" accept="image/jpeg,image/png">
                                            <small class="text-muted">Önerilen boyut: 200x200 piksel</small>
                                        </div>

                                        <div class="mb-3">
                                            <label for="magaza_foto" class="form-label">Mağaza Fotoğrafı</label>
                                            <?php if(!empty($ayarlar['magaza_foto'])): ?>
                                                <div class="mb-2">
                                                    <img src="../uploads/<?php echo $ayarlar['magaza_foto']; ?>" alt="Mevcut Mağaza Fotoğrafı" class="current-logo">
                                                </div>
                                            <?php endif; ?>
                                            <input type="file" class="form-control" id="magaza_foto" name="magaza_foto" accept="image/jpeg,image/png">
                                            <small class="text-muted">Önerilen boyut: 800x600 piksel</small>
                                        </div>

                                        <div class="mb-3">
                                            <label for="magaza_url" class="form-label">Google İşletme URL</label>
                                            <input type="url" class="form-control" id="magaza_url" name="magaza_url" value="<?php echo $ayarlar['magaza_url'] ?? ''; ?>">
                                            <small class="text-muted">Google İşletme sayfanızın URL'si</small>
                                        </div>

                                        <div class="mb-3">
                                            <label for="copyright" class="form-label">Telif Hakkı Metni</label>
                                            <input type="text" class="form-control" id="copyright" name="copyright" value="<?php echo $ayarlar['copyright'] ?? ''; ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Sosyal Medya Bağlantıları -->
                            <div class="card mb-4">
                                <div class="card-header" role="button" data-bs-toggle="collapse" data-bs-target="#sosyalMedya" aria-expanded="false">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-share-alt me-2"></i>
                                            Sosyal Medya Bağlantıları
                                        </h5>
                                        <i class="fas fa-chevron-down"></i>
                                    </div>
                                </div>
                                <div class="collapse" id="sosyalMedya">
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="facebook" class="form-label">Facebook URL</label>
                                            <input type="url" class="form-control" id="facebook" name="facebook" value="<?php echo $ayarlar['facebook'] ?? ''; ?>">
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="facebook_kullanici" class="form-label">Facebook Kullanıcı Adı</label>
                                            <input type="text" class="form-control" id="facebook_kullanici" name="facebook_kullanici" value="<?php echo $ayarlar['facebook_kullanici'] ?? ''; ?>" placeholder="badekafe">
                                            <small class="text-muted">Sadece kullanıcı adını girin (örn: badekafe)</small>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="instagram" class="form-label">Instagram URL</label>
                                            <input type="url" class="form-control" id="instagram" name="instagram" value="<?php echo $ayarlar['instagram'] ?? ''; ?>" placeholder="https://instagram.com/badekafe">
                                            <small class="text-muted">Tam URL girin (örn: https://instagram.com/badekafe)</small>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="instagram_kullanici" class="form-label">Instagram Kullanıcı Adı</label>
                                            <input type="text" class="form-control" id="instagram_kullanici" name="instagram_kullanici" value="<?php echo $ayarlar['instagram_kullanici'] ?? ''; ?>" placeholder="badekafe">
                                            <small class="text-muted">Sadece kullanıcı adını girin (örn: badekafe)</small>
                                        </div>

                                        <div class="mb-3">
                                            <label for="twitter" class="form-label">Twitter URL</label>
                                            <input type="url" class="form-control" id="twitter" name="twitter" value="<?php echo $ayarlar['twitter'] ?? ''; ?>">
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="twitter_kullanici" class="form-label">Twitter Kullanıcı Adı</label>
                                            <input type="text" class="form-control" id="twitter_kullanici" name="twitter_kullanici" value="<?php echo $ayarlar['twitter_kullanici'] ?? ''; ?>">
                                            <small class="text-muted">@ işareti olmadan kullanıcı adını girin</small>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="whatsapp" class="form-label">WhatsApp Numarası</label>
                                            <input type="text" class="form-control" id="whatsapp" name="whatsapp" value="<?php echo $ayarlar['whatsapp'] ?? ''; ?>">
                                            <small class="text-muted">Başında 0 olmadan yazın (örn: 5321234567)</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- WiFi Ayarları -->
                            <div class="card mb-4">
                                <div class="card-header" role="button" data-bs-toggle="collapse" data-bs-target="#wifiAyarlari" aria-expanded="false">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-wifi me-2"></i>
                                            WiFi Ayarları
                                        </h5>
                                        <i class="fas fa-chevron-down"></i>
                                    </div>
                                </div>
                                <div class="collapse" id="wifiAyarlari">
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="wifi_ag_adi" class="form-label">WiFi Ağ Adı</label>
                                            <input type="text" class="form-control" id="wifi_ag_adi" name="wifi_ag_adi" 
                                                   value="<?php echo $ayarlar['wifi_ag_adi'] ?? ''; ?>" 
                                                   placeholder="Örn: Cafe WiFi">
                                        </div>
                                        <div class="mb-3">
                                            <label for="wifi_sifre" class="form-label">WiFi Şifresi</label>
                                            <input type="text" class="form-control" id="wifi_sifre" name="wifi_sifre" 
                                                   value="<?php echo $ayarlar['wifi_sifre'] ?? ''; ?>" 
                                                   placeholder="Örn: Cafe1234">
                                        </div>
                                        <div class="mb-3">
                                            <label for="wifi_guvenlik" class="form-label">WiFi Güvenlik Türü</label>
                                            <select class="form-select" id="wifi_guvenlik" name="wifi_guvenlik">
                                                <option value="WPA2" <?php echo ($ayarlar['wifi_guvenlik'] ?? '') == 'WPA2' ? 'selected' : ''; ?>>WPA2</option>
                                                <option value="WPA3" <?php echo ($ayarlar['wifi_guvenlik'] ?? '') == 'WPA3' ? 'selected' : ''; ?>>WPA3</option>
                                                <option value="WPA/WPA2" <?php echo ($ayarlar['wifi_guvenlik'] ?? '') == 'WPA/WPA2' ? 'selected' : ''; ?>>WPA/WPA2</option>
                                                <option value="Açık Ağ" <?php echo ($ayarlar['wifi_guvenlik'] ?? '') == 'Açık Ağ' ? 'selected' : ''; ?>>Açık Ağ</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Stil Ayarları -->
                            <div class="card mb-4">
                                <div class="card-header" role="button" data-bs-toggle="collapse" data-bs-target="#stilAyarlari" aria-expanded="false">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h5 class="card-title mb-0">
                                            <i class="fas fa-paint-brush me-2"></i>
                                            Stil Ayarları
                                        </h5>
                                        <i class="fas fa-chevron-down"></i>
                                    </div>
                                </div>
                                <div class="collapse" id="stilAyarlari">
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="header_bg_color" class="form-label">Header Arkaplan Rengi</label>
                                            <div class="input-group">
                                                <input type="color" class="form-control form-control-color" id="header_bg_color" name="header_bg_color" 
                                                       value="<?php echo $ayarlar['header_bg_color'] ?? '#343a40'; ?>" title="Header rengi seçin">
                                                <input type="text" class="form-control" value="<?php echo $ayarlar['header_bg_color'] ?? '#343a40'; ?>" 
                                                       data-color-input="header_bg_color" placeholder="#343a40" pattern="^#[0-9A-Fa-f]{6}$">
                                            </div>
                                            <small class="text-muted">Üst menü arkaplan rengi (Hex kodu ile de girebilirsiniz, örn: #343a40)</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Header İkonları</label>
                                            <div class="d-flex gap-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="header_icon_color" id="header_icon_light" 
                                                           value="#ffffff" <?php echo ($ayarlar['header_icon_color'] ?? '#ffffff') == '#ffffff' ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="header_icon_light">
                                                        Açık Renk
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="header_icon_color" id="header_icon_dark" 
                                                           value="#000000" <?php echo ($ayarlar['header_icon_color'] ?? '#ffffff') == '#000000' ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="header_icon_dark">
                                                        Koyu Renk
                                                    </label>
                                                </div>
                                            </div>
                                            <small class="text-muted">Header'daki ikonların rengi</small>
                                        </div>

                                        <div class="mb-3">
                                            <label for="bottom_bar_bg_color" class="form-label">Bottom Bar Arkaplan Rengi</label>
                                            <div class="input-group">
                                                <input type="color" class="form-control form-control-color" id="bottom_bar_bg_color" name="bottom_bar_bg_color" 
                                                       value="<?php echo $ayarlar['bottom_bar_bg_color'] ?? '#000000'; ?>" title="Bottom bar rengi seçin">
                                                <input type="text" class="form-control" value="<?php echo $ayarlar['bottom_bar_bg_color'] ?? '#000000'; ?>" 
                                                       data-color-input="bottom_bar_bg_color" placeholder="#000000" pattern="^#[0-9A-Fa-f]{6}$">
                                            </div>
                                            <small class="text-muted">Alt menü arkaplan rengi (Hex kodu ile de girebilirsiniz, örn: #000000)</small>
                                        </div>

                                        <div class="mb-3">
                                            <label class="form-label">Bottom Bar İkonları ve Yazıları</label>
                                            <div class="d-flex gap-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="bottom_bar_icon_color" id="bottom_bar_icon_light" 
                                                           value="#ffffff" <?php echo ($ayarlar['bottom_bar_icon_color'] ?? '#ffffff') == '#ffffff' ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="bottom_bar_icon_light">
                                                        Açık Renk
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="bottom_bar_icon_color" id="bottom_bar_icon_dark" 
                                                           value="#000000" <?php echo ($ayarlar['bottom_bar_icon_color'] ?? '#ffffff') == '#000000' ? 'checked' : ''; ?>>
                                                    <label class="form-check-label" for="bottom_bar_icon_dark">
                                                        Koyu Renk
                                                    </label>
                                                </div>
                                            </div>
                                            <small class="text-muted">Bottom bar'daki ikonların ve yazıların rengi</small>
                                        </div>

                                        <div class="mb-3">
                                            <label for="feedback_circle_color" class="form-label">Feedback Butonu Rengi</label>
                                            <div class="input-group">
                                                <input type="color" class="form-control form-control-color" id="feedback_circle_color" name="feedback_circle_color" 
                                                       value="<?php echo $ayarlar['feedback_circle_color'] ?? '#dc3545'; ?>" title="Feedback butonu rengi seçin">
                                                <input type="text" class="form-control" value="<?php echo $ayarlar['feedback_circle_color'] ?? '#dc3545'; ?>" 
                                                       data-color-input="feedback_circle_color" placeholder="#dc3545" pattern="^#[0-9A-Fa-f]{6}$">
                                            </div>
                                            <small class="text-muted">Ortadaki yuvarlak geri bildirim butonunun rengi (Hex kodu ile de girebilirsiniz, örn: #dc3545)</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Güncelleme butonu -->
                            <div class="mt-4">
                                <button type="submit" name="ayarlar_guncelle" class="btn btn-primary">Ayarları Güncelle</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sidebar toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Sidebar close
        document.getElementById('sidebarClose').addEventListener('click', function() {
            document.getElementById('sidebar').classList.remove('show');
        });

        // Sağ tarafta boş alana tıklanınca sidebar'ı kapat
        document.getElementById('contentArea').addEventListener('click', function(event) {
            if (document.getElementById('sidebar').classList.contains('show') && event.target.id !== 'sidebarToggle') {
                document.getElementById('sidebar').classList.remove('show');
            }
        });

        // Tüm collapse elementlerini seç
        const collapseElements = document.querySelectorAll('.collapse');
        
        // Bootstrap Collapse nesnelerini oluştur
        collapseElements.forEach(element => {
            new bootstrap.Collapse(element, {
                toggle: false
            });
        });

        // Başlık tıklamalarını dinle
        document.querySelectorAll('.card-header[role="button"]').forEach(header => {
            header.addEventListener('click', function() {
                const icon = this.querySelector('.fa-chevron-down');
                const isExpanded = this.getAttribute('aria-expanded') === 'true';
                
                // İkon rotasyonunu güncelle
                if (isExpanded) {
                    icon.style.transform = 'rotate(0deg)';
                } else {
                    icon.style.transform = 'rotate(180deg)';
                }
            });
        });

        // Renk seçici ve hex input eşleştirmesi
        document.querySelectorAll('input[type="color"]').forEach(colorInput => {
            colorInput.addEventListener('input', function() {
                // Yanındaki hex input'u güncelle
                const hexInput = this.parentElement.querySelector('[data-color-input]');
                hexInput.value = this.value.toUpperCase();
            });
        });

        // Hex input değişikliklerini renk seçiciye yansıtma
        document.querySelectorAll('[data-color-input]').forEach(hexInput => {
            hexInput.addEventListener('input', function() {
                // Hex değerini doğrula
                let hexValue = this.value.trim();
                
                // # işareti yoksa ekle
                if (!hexValue.startsWith('#')) {
                    hexValue = '#' + hexValue;
                }
                
                // Hex kodu geçerliyse renk seçiciyi güncelle
                if (/^#[0-9A-Fa-f]{6}$/i.test(hexValue)) {
                    const colorInput = this.parentElement.querySelector('input[type="color"]');
                    colorInput.value = hexValue;
                    this.style.borderColor = '#ced4da'; // Normal border rengi
                } else {
                    this.style.borderColor = '#dc3545'; // Hatalı girişte kırmızı border
                }
            });

            // Hex input'tan focus kalktığında
            hexInput.addEventListener('blur', function() {
                let hexValue = this.value.trim();
                
                // # işareti yoksa ekle
                if (!hexValue.startsWith('#')) {
                    hexValue = '#' + hexValue;
                }
                
                // Hex kodunu büyük harfe çevir
                this.value = hexValue.toUpperCase();
                
                // Geçerli hex kodu değilse varsayılan değere geri dön
                if (!/^#[0-9A-Fa-f]{6}$/i.test(hexValue)) {
                    const colorInput = this.parentElement.querySelector('input[type="color"]');
                    this.value = colorInput.value;
                    this.style.borderColor = '#ced4da';
                }
            });
        });
    });
    </script>
</body>
</html> 