<?php
require_once 'auth.php';
require_once '../config/db.php';
session_start();

if(!isset($_SESSION['admin'])) {
    die(json_encode(['error' => 'Unauthorized']));
}

$days = isset($_GET['days']) ? intval($_GET['days']) : 7;

try {
    $dates = [];
    $complaints = [];
    
    for($i = $days - 1; $i >= 0; $i--) {
        $date = date('Y-m-d', strtotime("-$i days"));
        $dates[] = date('d.m', strtotime($date));
        
        // O gün için şikayet sayısını al
        $stmt = $conn->prepare("SELECT COUNT(*) FROM sikayetler WHERE DATE(tarih) = ?");
        $stmt->execute([$date]);
        $complaints[] = (int)$stmt->fetchColumn();
    }
    
    // Toplam şikayet sayısını da ekleyelim
    $total_complaints = $conn->query("SELECT COUNT(*) FROM sikayetler")->fetchColumn();
    $unread_complaints = $conn->query("SELECT COUNT(*) FROM sikayetler WHERE okundu = 0")->fetchColumn();
    
    echo json_encode([
        'dates' => $dates,
        'complaints' => $complaints,
        'totals' => [
            'total_complaints' => (int)$total_complaints,
            'unread_complaints' => (int)$unread_complaints
        ]
    ]);
    
} catch(PDOException $e) {
    echo json_encode([
        'error' => $e->getMessage(),
        'sql_state' => $e->getCode()
    ]);
} 