<?php
require_once 'auth.php';
require_once '../config/db.php';
session_start();

if(!isset($_SESSION['admin'])) {
    die(json_encode(['error' => 'Unauthorized']));
}

$days = isset($_GET['days']) ? intval($_GET['days']) : 7;

try {
    $dates = [];
    $likes = [];
    $dislikes = [];
    
    for($i = $days - 1; $i >= 0; $i--) {
        $date = date('Y-m-d', strtotime("-$i days"));
        $dates[] = date('d.m', strtotime($date));
        
        // Like sayısını al
        $stmt = $conn->prepare("SELECT COUNT(*) FROM urun_degerlendirmeleri 
                               WHERE degerlendirme_tipi = 'like' 
                               AND DATE(tarih) = ?");
        $stmt->execute([$date]);
        $likes[] = (int)$stmt->fetchColumn();
        
        // Dislike sayısını al
        $stmt = $conn->prepare("SELECT COUNT(*) FROM urun_degerlendirmeleri 
                               WHERE degerlendirme_tipi = 'dislike' 
                               AND DATE(tarih) = ?");
        $stmt->execute([$date]);
        $dislikes[] = (int)$stmt->fetchColumn();
    }
    
    // Toplam değerlendirme sayılarını da ekleyelim
    $total_likes = $conn->query("SELECT COUNT(*) FROM urun_degerlendirmeleri WHERE degerlendirme_tipi = 'like'")->fetchColumn();
    $total_dislikes = $conn->query("SELECT COUNT(*) FROM urun_degerlendirmeleri WHERE degerlendirme_tipi = 'dislike'")->fetchColumn();
    
    echo json_encode([
        'dates' => $dates,
        'likes' => $likes,
        'dislikes' => $dislikes,
        'totals' => [
            'total_likes' => (int)$total_likes,
            'total_dislikes' => (int)$total_dislikes
        ]
    ]);
    
} catch(PDOException $e) {
    echo json_encode([
        'error' => $e->getMessage(),
        'sql_state' => $e->getCode()
    ]);
} 