<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    die('Yetkisiz erişim');
}

if($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kaynak_id = $_POST['kaynak_id'];
    $yeni_ad = $_POST['yeni_ad'];
    
    try {
        // Kaynak kategoriyi al
        $stmt = $conn->prepare("SELECT * FROM kategoriler WHERE id = ?");
        $stmt->execute([$kaynak_id]);
        $kaynak_kategori = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($kaynak_kategori) {
            // Yeni kategoriyi ekle
            $stmt = $conn->prepare("INSERT INTO kategoriler (kategori_adi) VALUES (?)");
            $stmt->execute([$yeni_ad]);
            $yeni_id = $conn->lastInsertId();
            
            // Resimleri kopyala (hem jpg hem webp)
            $kaynak_resim_jpg = "../uploads/kategori_{$kaynak_id}.jpg";
            $kaynak_resim_webp = "../uploads/kategori_{$kaynak_id}.webp";
            
            if(file_exists($kaynak_resim_jpg)) {
                copy($kaynak_resim_jpg, "../uploads/kategori_{$yeni_id}.jpg");
            }
            if(file_exists($kaynak_resim_webp)) {
                copy($kaynak_resim_webp, "../uploads/kategori_{$yeni_id}.webp");
            }
            
            header('Location: kategoriler.php?mesaj=kopyalandi');
        }
    } catch(PDOException $e) {
        header('Location: kategoriler.php?mesaj=hata');
    }
} 