<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Şikayet Silme
if(isset($_GET['sil'])) {
    $id = $_GET['sil'];
    $stmt = $conn->prepare("DELETE FROM sikayetler WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: sikayet.php?mesaj=silindi");
}

// Şikayet Okundu İşaretleme
if(isset($_GET['okundu'])) {
    $id = $_GET['okundu'];
    $stmt = $conn->prepare("UPDATE sikayetler SET okundu = 1 WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: sikayet.php?mesaj=okundu");
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Şikayetler - QR Menü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            padding-top: 20px;
            z-index: 1000;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            display: block;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .content {
            padding: 20px;
        }
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                width: 250px;
                height: 100%;
                transition: left 0.3s ease;
                z-index: 1000;
            }
            .sidebar.show {
                left: 0;
            }
            #sidebarClose {
                display: inline; /* Mobilde göster */
            }
        }
        @media (min-width: 769px) {
            #sidebarClose {
                display: none; /* Masaüstünde gizle */
            }
        }
        .okunmamis {
            background-color: #fff3cd;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <button class="btn btn-primary d-md-none" id="sidebarToggle">Menüyü Göster</button>
        <div class="row">
            <div class="col-md-2 sidebar" id="sidebar">
                <h3 class="text-white text-center mb-4">QR Menü Admin <span id="sidebarClose" style="cursor: pointer; color: white;">&times;</span></h3>
                <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                <a href="kategoriler.php"><i class="fas fa-list"></i> Kategoriler</a>
                <a href="urunler.php"><i class="fas fa-utensils"></i> Ürünler</a>
                <a href="sikayet.php"><i class="fas fa-comment-alt"></i> Şikayetler</a>
                <a href="qr.php"><i class="fas fa-qrcode"></i> QR Kodlar</a>
                <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </div>
            
            <div class="col-md-10 content" id="contentArea">
                <h2 class="mb-4">Şikayetler</h2>
                
                <?php if(isset($_GET['mesaj'])): ?>
                    <?php if($_GET['mesaj'] == 'silindi'): ?>
                        <div class="alert alert-success">Şikayet başarıyla silindi.</div>
                    <?php elseif($_GET['mesaj'] == 'okundu'): ?>
                        <div class="alert alert-success">Şikayet okundu olarak işaretlendi.</div>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Şikayetler Listesi -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Gelen Şikayetler</h5>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Müşteri Adı</th>
                                    <th>E-posta</th>
                                    <th>Konu</th>
                                    <th>Mesaj</th>
                                    <th>Tarih</th>
                                    <th>Durum</th>
                                    <th>İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $stmt = $conn->query("SELECT * FROM sikayetler ORDER BY id DESC");
                                while($sikayet = $stmt->fetch(PDO::FETCH_ASSOC)):
                                ?>
                                <tr class="<?php echo $sikayet['okundu'] ? '' : 'okunmamis'; ?>">
                                    <td><?php echo $sikayet['id']; ?></td>
                                    <td><?php echo $sikayet['musteri_adi']; ?></td>
                                    <td><?php echo $sikayet['email']; ?></td>
                                    <td><?php echo $sikayet['konu']; ?></td>
                                    <td><?php echo nl2br($sikayet['mesaj']); ?></td>
                                    <td><?php echo date('d.m.Y H:i', strtotime($sikayet['tarih'])); ?></td>
                                    <td>
                                        <?php if($sikayet['okundu']): ?>
                                            <span class="badge bg-success">Okundu</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning">Okunmadı</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info view-complaint" 
                                                data-bs-toggle="modal" 
                                                data-bs-target="#complaintModal"
                                                data-id="<?php echo $sikayet['id']; ?>"
                                                data-name="<?php echo htmlspecialchars($sikayet['musteri_adi']); ?>"
                                                data-email="<?php echo htmlspecialchars($sikayet['email']); ?>"
                                                data-subject="<?php echo htmlspecialchars($sikayet['konu']); ?>"
                                                data-message="<?php echo htmlspecialchars($sikayet['mesaj']); ?>"
                                                data-date="<?php echo date('d.m.Y H:i', strtotime($sikayet['tarih'])); ?>"
                                                data-read="<?php echo $sikayet['okundu']; ?>">
                                            <i class="fas fa-eye"></i> Detaylar
                                        </button>
                                        <a href="?sil=<?php echo $sikayet['id']; ?>" class="btn btn-sm btn-danger" 
                                           onclick="return confirm('Bu şikayeti silmek istediğinizden emin misiniz?')">
                                            <i class="fas fa-trash"></i> Sil
                                        </a>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Şikayet Detay Modal -->
    <div class="modal fade" id="complaintModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Şikayet Detayı</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>Müşteri Adı:</strong>
                            <p id="modalCustomerName"></p>
                        </div>
                        <div class="col-md-6">
                            <strong>E-posta:</strong>
                            <p id="modalEmail"></p>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>Tarih:</strong>
                            <p id="modalDate"></p>
                        </div>
                        <div class="col-md-6">
                            <strong>Durum:</strong>
                            <p id="modalStatus"></p>
                        </div>
                    </div>
                    <div class="mb-3">
                        <strong>Konu:</strong>
                        <p id="modalSubject"></p>
                    </div>
                    <div class="mb-3">
                        <strong>Mesaj:</strong>
                        <p id="modalMessage" style="white-space: pre-line;"></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                    <button type="button" class="btn btn-success" id="markAsRead">
                        <i class="fas fa-check"></i> Okundu Olarak İşaretle
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sidebar toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Sidebar close
        document.getElementById('sidebarClose').addEventListener('click', function() {
            document.getElementById('sidebar').classList.remove('show');
        });

        // Sağ tarafta boş alana tıklanınca sidebar'ı kapat
        document.getElementById('contentArea').addEventListener('click', function(event) {
            if (document.getElementById('sidebar').classList.contains('show') && event.target.id !== 'sidebarToggle') {
                document.getElementById('sidebar').classList.remove('show');
            }
        });

        // Detay butonuna tıklandığında
        document.querySelectorAll('.view-complaint').forEach(button => {
            button.addEventListener('click', function() {
                const modal = document.getElementById('complaintModal');
                
                // Modal içeriğini doldur
                document.getElementById('modalCustomerName').textContent = this.dataset.name;
                document.getElementById('modalEmail').textContent = this.dataset.email;
                document.getElementById('modalSubject').textContent = this.dataset.subject;
                document.getElementById('modalMessage').textContent = this.dataset.message;
                document.getElementById('modalDate').textContent = this.dataset.date;
                
                // Durum badge'ini ayarla
                const isRead = parseInt(this.dataset.read);
                document.getElementById('modalStatus').innerHTML = isRead ? 
                    '<span class="badge bg-success">Okundu</span>' : 
                    '<span class="badge bg-warning">Okunmadı</span>';
                
                // Okundu butonunu ayarla
                const markAsReadBtn = document.getElementById('markAsRead');
                if(isRead) {
                    markAsReadBtn.style.display = 'none';
                } else {
                    markAsReadBtn.style.display = 'block';
                    markAsReadBtn.onclick = () => {
                        window.location.href = `?okundu=${this.dataset.id}`;
                    }
                }
            });
        });
    });
    </script>
</body>
</html> 