<?php
// Hata raporlamayı aktif et
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

if(!isset($_GET['id'])) {
    header("Location: urunler.php");
    exit;
}

$id = $_GET['id'];

// Ürün Güncelleme
if(isset($_POST['urun_guncelle'])) {
    $kategori_id = $_POST['kategori_id'];
    $urun_adi = $_POST['urun_adi'];
    $fiyat = $_POST['fiyat'];
    $aciklama = $_POST['aciklama'];
    $stok_durumu = $_POST['stok_durumu'];
    $populer = isset($_POST['populer']) ? 1 : 0;
    
    // Alerjen değerlerini al
    $gluten = isset($_POST['gluten']) ? 1 : 0;
    $sut = isset($_POST['sut']) ? 1 : 0;
    $soya = isset($_POST['soya']) ? 1 : 0;
    $yumurta = isset($_POST['yumurta']) ? 1 : 0;
    
    // Mevcut resmi al
    $stmt = $conn->prepare("SELECT resim FROM urunler WHERE id = ?");
    $stmt->execute([$id]);
    $urun = $stmt->fetch(PDO::FETCH_ASSOC);
    $resim = $urun['resim'];
    
    // Yeni resim yükleme
    if(isset($_FILES['resim']) && $_FILES['resim']['error'] == 0) {
        $izin_verilen_uzantilar = array('jpg', 'jpeg', 'png');
        $dosya_uzantisi = strtolower(pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION));
        
        if(in_array($dosya_uzantisi, $izin_verilen_uzantilar)) {
            // Eski resmi sil
            if($resim && file_exists('../uploads/' . $resim)) {
                unlink('../uploads/' . $resim);
            }
            
            // Yeni resmi yükle
            $yeni_isim = uniqid();
            $hedef_yol = '../uploads/' . $yeni_isim;
            
            // GD kütüphanesi kontrolü
            if (!extension_loaded('gd')) {
                error_log('GD kütüphanesi yüklü değil!');
                // GD yoksa direkt orijinal dosyayı kaydet
                if(move_uploaded_file($_FILES['resim']['tmp_name'], $hedef_yol . '.' . $dosya_uzantisi)) {
                    $resim = $yeni_isim . '.' . $dosya_uzantisi;
                    error_log('GD olmadığı için orijinal dosya yüklendi: ' . $resim);
                }
            } else {
                // Orijinal resmi yükle
                if(move_uploaded_file($_FILES['resim']['tmp_name'], $hedef_yol . '.' . $dosya_uzantisi)) {
                    error_log('Orijinal dosya başarıyla yüklendi: ' . $hedef_yol . '.' . $dosya_uzantisi);
                    
                    // WebP'ye dönüştür
                    $kaynak_resim = null;
                    
                    // Kaynak resmi yükle
                    if($dosya_uzantisi == 'jpg' || $dosya_uzantisi == 'jpeg') {
                        $kaynak_resim = @imagecreatefromjpeg($hedef_yol . '.' . $dosya_uzantisi);
                        error_log('JPEG/JPG dosyası yükleme denemesi');
                    } else if($dosya_uzantisi == 'png') {
                        $kaynak_resim = @imagecreatefrompng($hedef_yol . '.' . $dosya_uzantisi);
                        error_log('PNG dosyası yükleme denemesi');
                    }
                    
                    if($kaynak_resim) {
                        error_log('Kaynak resim başarıyla oluşturuldu');
                        // WebP olarak kaydet
                        if(imagewebp($kaynak_resim, $hedef_yol . '.webp', 80)) {
                            error_log('WebP dönüşümü başarılı: ' . $hedef_yol . '.webp');
                            
                            // Belleği temizle
                            imagedestroy($kaynak_resim);
                            
                            // Orijinal dosyayı sil
                            if(unlink($hedef_yol . '.' . $dosya_uzantisi)) {
                                error_log('Orijinal dosya silindi');
                            } else {
                                error_log('Orijinal dosya silinemedi');
                            }
                            
                            // Veritabanı için WebP dosya adını kaydet
                            $resim = $yeni_isim . '.webp';
                        } else {
                            error_log('WebP dönüşümü başarısız. PHP hatası: ' . error_get_last()['message']);
                            // WebP dönüşümü başarısız olursa orijinal dosyayı kullan
                            $resim = $yeni_isim . '.' . $dosya_uzantisi;
                        }
                    } else {
                        error_log('Kaynak resim oluşturulamadı. PHP hatası: ' . error_get_last()['message']);
                        $resim = $yeni_isim . '.' . $dosya_uzantisi;
                    }
                } else {
                    error_log('Dosya yükleme hatası: ' . error_get_last()['message']);
                }
            }
        }
    }
    
    // Yeni alerjen değerlerini al
    $balik = isset($_POST['balik']) ? 1 : 0;
    $yerfistigi = isset($_POST['yerfistigi']) ? 1 : 0;
    $kabuklular = isset($_POST['kabuklular']) ? 1 : 0;
    
    $stmt = $conn->prepare("UPDATE urunler SET 
        kategori_id = ?, 
        urun_adi = ?, 
        fiyat = ?, 
        aciklama = ?, 
        resim = ?, 
        stok_durumu = ?, 
        populer = ?,
        gluten = ?,
        sut = ?,
        soya = ?,
        yumurta = ?,
        balik = ?,
        yerfistigi = ?,
        kabuklular = ?
        WHERE id = ?");
    
    $stmt->execute([
        $kategori_id, 
        $urun_adi, 
        $fiyat, 
        $aciklama, 
        $resim, 
        $stok_durumu, 
        $populer,
        $gluten,
        $sut,
        $soya,
        $yumurta,
        $balik,
        $yerfistigi,
        $kabuklular,
        $id
    ]);
    
    header("Location: urunler.php?mesaj=guncellendi");
}

// Ürün bilgilerini al
$stmt = $conn->prepare("SELECT * FROM urunler WHERE id = ?");
$stmt->execute([$id]);
$urun = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$urun) {
    header("Location: urunler.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ürün Düzenle - QR Menü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            padding-top: 20px;
            z-index: 1000;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            display: block;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .content {
            padding: 20px;
        }
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                width: 250px;
                height: 100%;
                transition: left 0.3s ease;
                z-index: 1000;
            }
            .sidebar.show {
                left: 0;
            }
            #sidebarClose {
                display: inline; /* Mobilde göster */
            }
        }
        @media (min-width: 769px) {
            #sidebarClose {
                display: none; /* Masaüstünde gizle */
            }
        }
        .urun-resim {
            max-width: 200px;
            max-height: 200px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <button class="btn btn-primary d-md-none" id="sidebarToggle">Menüyü Göster</button>
        <div class="row">
            <div class="col-md-2 sidebar" id="sidebar">
                <h3 class="text-white text-center mb-4">QR Menü Admin <span id="sidebarClose" style="cursor: pointer; color: white;">&times;</span></h3>
                <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                <a href="kategoriler.php"><i class="fas fa-list"></i> Kategoriler</a>
                <a href="urunler.php"><i class="fas fa-utensils"></i> Ürünler</a>
                <a href="sikayet.php"><i class="fas fa-comment-alt"></i> Şikayetler</a>
                <a href="qr.php"><i class="fas fa-qrcode"></i> QR Kodlar</a>
                <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </div>
            
            <div class="col-md-10 content" id="contentArea">
                <h2 class="mb-4">Ürün Düzenle</h2>
                
                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="kategori_id" class="form-label">Kategori</label>
                                <select class="form-control" id="kategori_id" name="kategori_id" required>
                                    <?php
                                    $stmt = $conn->query("SELECT * FROM kategoriler ORDER BY kategori_adi");
                                    while($kategori = $stmt->fetch(PDO::FETCH_ASSOC)):
                                    ?>
                                    <option value="<?php echo $kategori['id']; ?>" <?php echo ($kategori['id'] == $urun['kategori_id']) ? 'selected' : ''; ?>>
                                        <?php echo $kategori['kategori_adi']; ?>
                                    </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="urun_adi" class="form-label">Ürün Adı</label>
                                <input type="text" class="form-control" id="urun_adi" name="urun_adi" value="<?php echo $urun['urun_adi']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="fiyat" class="form-label">Fiyat</label>
                                <input type="number" step="0.01" class="form-control" id="fiyat" name="fiyat" value="<?php echo $urun['fiyat']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="aciklama" class="form-label">Açıklama</label>
                                <textarea class="form-control" id="aciklama" name="aciklama" rows="3"><?php echo $urun['aciklama']; ?></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="stok_durumu" class="form-label">Stok Durumu</label>
                                <select class="form-control" id="stok_durumu" name="stok_durumu" required>
                                    <option value="1" <?php echo ($urun['stok_durumu'] == 1) ? 'selected' : ''; ?>>Stokta Var</option>
                                    <option value="0" <?php echo ($urun['stok_durumu'] == 0) ? 'selected' : ''; ?>>Stokta Yok</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="populer" name="populer" <?php echo ($urun['populer'] == 1) ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="populer">
                                        Popüler Ürün
                                    </label>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="resim" class="form-label">Ürün Resmi</label>
                                <?php if($urun['resim']): ?>
                                    <div class="mb-2">
                                        <img src="../uploads/<?php echo $urun['resim']; ?>" class="urun-resim">
                                    </div>
                                <?php endif; ?>
                                <input type="file" class="form-control" id="resim" name="resim">
                                <small class="text-muted">Yeni resim seçmezseniz mevcut resim korunacaktır.</small>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Gıda Alerjenleri</label>
                                <div class="d-flex gap-3 flex-wrap">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="gluten" name="gluten" 
                                               <?php echo isset($urun['gluten']) && $urun['gluten'] ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="gluten">
                                            <i class="fas fa-bread-slice"></i> Gluten
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="sut" name="sut"
                                               <?php echo isset($urun['sut']) && $urun['sut'] ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="sut">
                                            <i class="fas fa-glass-whiskey"></i> Süt
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="soya" name="soya"
                                               <?php echo $urun['soya'] ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="soya">
                                            <i class="fas fa-seedling"></i> Soya
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="yumurta" name="yumurta"
                                               <?php echo $urun['yumurta'] ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="yumurta">
                                            <i class="fas fa-egg"></i> Yumurta
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="balik" name="balik"
                                               <?php echo $urun['balik'] ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="balik">
                                            <i class="fas fa-fish"></i> Balık
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="yerfistigi" name="yerfistigi"
                                               <?php echo $urun['yerfistigi'] ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="yerfistigi">
                                            <i class="fas fa-leaf"></i> Yer Fıstığı
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="kabuklular" name="kabuklular"
                                               <?php echo $urun['kabuklular'] ? 'checked' : ''; ?>>
                                        <label class="form-check-label" for="kabuklular">
                                            <i class="fas fa-water"></i> Kabuklular
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <button type="submit" name="urun_guncelle" class="btn btn-primary">Güncelle</button>
                            <a href="urunler.php" class="btn btn-secondary">İptal</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sidebar toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Sidebar close
        document.getElementById('sidebarClose').addEventListener('click', function() {
            document.getElementById('sidebar').classList.remove('show');
        });

        // Sağ tarafta boş alana tıklanınca sidebar'ı kapat
        document.getElementById('contentArea').addEventListener('click', function(event) {
            if (document.getElementById('sidebar').classList.contains('show') && event.target.id !== 'sidebarToggle') {
                document.getElementById('sidebar').classList.remove('show');
            }
        });
    });
    </script>
</body>
</html> 