<?php
require_once 'config/db.php';

if(isset($_GET['id'])) {
    $id = intval($_GET['id']);
    
    $stmt = $conn->prepare("SELECT * FROM urunler WHERE id = ?");
    $stmt->execute([$id]);
    $urun = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if($urun) {
        ?>
        <div class="product-detail">
            <div class="text-center mb-4">
                <?php if($urun['resim']): ?>
                    <img src="uploads/<?php echo $urun['resim']; ?>" 
                         alt="<?php echo $urun['urun_adi']; ?>" 
                         class="img-fluid rounded" 
                         style="max-height: 300px; object-fit: cover;">
                <?php else: ?>
                    <img src="uploads/default.jpg" 
                         alt="Varsayılan ürün resmi" 
                         class="img-fluid rounded">
                <?php endif; ?>
            </div>
            
            <h4 class="mb-3"><?php echo $urun['urun_adi']; ?></h4>
            
            <p class="text-muted"><?php echo $urun['aciklama']; ?></p>
            
            <div class="d-flex justify-content-between align-items-center mb-3">
                <span class="fs-4 fw-bold text-success"><?php echo number_format($urun['fiyat'], 2); ?> ₺</span>
                <?php if($urun['stok_durumu'] == 0): ?>
                    <span class="badge bg-danger">Stokta Yok</span>
                <?php else: ?>
                    <span class="badge bg-success">Stokta Var</span>
                <?php endif; ?>
            </div>

            <div class="allergens mb-3">
                <?php if($urun['gluten'] || $urun['sut'] || $urun['soya'] || $urun['yumurta'] || 
                          $urun['balik'] || $urun['yerfistigi'] || $urun['kabuklular']): ?>
                    <h6 class="text-muted mb-2">Alerjenler:</h6>
                    <div class="d-flex gap-2 flex-wrap">
                        <?php if($urun['gluten']): ?>
                            <div class="allergen-icon" data-bs-toggle="tooltip" title="Gluten">
                                <i class="fas fa-bread-slice"></i>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($urun['sut']): ?>
                            <div class="allergen-icon" data-bs-toggle="tooltip" title="Süt">
                                <i class="fas fa-glass-whiskey"></i>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($urun['soya']): ?>
                            <div class="allergen-icon" data-bs-toggle="tooltip" title="Soya">
                                <i class="fas fa-seedling"></i>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($urun['yumurta']): ?>
                            <div class="allergen-icon" data-bs-toggle="tooltip" title="Yumurta">
                                <i class="fas fa-egg"></i>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($urun['balik']): ?>
                            <div class="allergen-icon" data-bs-toggle="tooltip" title="Balık">
                                <i class="fas fa-fish"></i>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($urun['yerfistigi']): ?>
                            <div class="allergen-icon" data-bs-toggle="tooltip" title="Yer Fıstığı">
                                <i class="fas fa-leaf"></i>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($urun['kabuklular']): ?>
                            <div class="allergen-icon" data-bs-toggle="tooltip" title="Kabuklular">
                                <i class="fas fa-water"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>

            <div class="rating-section border-top pt-3 mt-3">
                <h5 class="mb-3">Ürün Değerlendirmesi</h5>
                <div class="d-flex justify-content-between align-items-center">
                    <div class="rating-buttons">
                        <button class="btn btn-outline-success me-2" onclick="rateProduct(<?php echo $urun['id']; ?>, 'like')">
                            <i class="fas fa-thumbs-up"></i>
                            <span class="like-count"><?php echo $urun['begeni_sayisi']; ?></span>
                        </button>
                        <button class="btn btn-outline-danger" onclick="rateProduct(<?php echo $urun['id']; ?>, 'dislike')">
                            <i class="fas fa-thumbs-down"></i>
                            <span class="dislike-count"><?php echo $urun['begenmeme_sayisi']; ?></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <?php
    } else {
        echo '<div class="alert alert-danger">Ürün bulunamadı.</div>';
    }
} else {
    echo '<div class="alert alert-danger">Geçersiz ürün ID.</div>';
}
?>

<style>
.allergen-icon {
    width: 30px;
    height: 30px;
    background: #f8f9fa;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: help;
}

.allergen-icon i {
    color: #6c757d;
    font-size: 16px;
}
</style>

<script>
// Tooltip'leri aktifleştir
var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl)
})
</script> 