<?php
require_once 'config/db.php';

// İşletme bilgilerini al
$stmt = $conn->query("SELECT * FROM ayarlar WHERE id = 1");
$ayarlar = $stmt->fetch(PDO::FETCH_ASSOC);

// Sosyal medya kullanıcı adını URL'den ayıklama fonksiyonu
function extractUsername($url, $platform) {
    if (empty($url)) return '';
    
    // URL'den son kısmı al
    $username = explode('/', rtrim($url, '/'));
    $username = end($username);
    
    // Eğer tam URL girilmişse (örn: @https://facebook.com/badekafe)
    if (strpos($username, '@') === 0) {
        $username = substr($username, 1);
        if (strpos($username, 'http') === 0) {
            $parts = explode('/', $username);
            $username = end($parts);
        }
    }
    
    return $username;
}

$ip_adresi = $_SERVER['REMOTE_ADDR'];
$sayfa = $_SERVER['REQUEST_URI'];

// Ziyaretçiyi kaydet
$stmt = $conn->prepare("INSERT INTO site_ziyaretleri (ip_adresi, sayfa) VALUES (?, ?)");
$stmt->execute([$ip_adresi, $sayfa]);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($ayarlar['site_basligi']) ? htmlspecialchars($ayarlar['site_basligi']) : 'QR Menü'; ?></title>
    <meta name="description" content="<?php echo isset($ayarlar['site_aciklamasi']) ? htmlspecialchars($ayarlar['site_aciklamasi']) : ''; ?>">
    <meta name="keywords" content="<?php echo isset($ayarlar['site_etiketleri']) ? htmlspecialchars($ayarlar['site_etiketleri']) : ''; ?>">
            <link rel="icon" href="<?php echo isset($ayarlar['favicon']) ? '../uploads/' . htmlspecialchars($ayarlar['favicon']) : 'default_favicon.ico'; ?>" type="image/x-icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        
        /* Loader Styles */
        .loader-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.5s ease-out;
        }
        
        .loader-container.fade-out {
            opacity: 0;
        }
        
        .loader {
            width: 150px;
            height: 150px;
            display: flex;
            justify-content: center;
            align-items: center;
            animation: pulse 1.5s ease-in-out infinite;
        }
        
        .loader img {
            max-width: 100%;
            height: auto;
        }
        
        @keyframes pulse {
            0% { transform: scale(0.95); }
            50% { transform: scale(1.05); }
            100% { transform: scale(0.95); }
        }
        
        .category-card {
            position: relative;
            margin-bottom: 20px;
            border-radius: 10px;
            overflow: hidden;
            cursor: pointer;
            height: 100px;
        }
        .category-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .category-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }
        .category-overlay:hover {
            background: rgba(0, 0, 0, 0.7);
        }
        .category-title {
            color: white;
            font-size: 24px;
            font-weight: bold;
            text-align: center;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
        }
        .product-section {
            display: none;
        }
        .product-card {
            margin-bottom: 20px;
            transition: transform 0.3s;
            border: 1px solid #dee2e6;
            border-radius: 10px;
            overflow: hidden;
            height: 100%;
        }
        .product-card .d-flex {
            height: 100%;
        }
        .product-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .product-card.out-of-stock {
            opacity: 0.7;
        }
        .product-card.out-of-stock img {
            filter: grayscale(100%);
        }
        .product-image-container {
            width: 120px;
            height: 120px;
            overflow: hidden;
            flex-shrink: 0;
        }
        .product-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        .product-details {
            padding: 12px;
            flex: 1;
        }
        .product-title {
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 8px;
            color: #333;
        }
        .product-description {
            color: #6c757d;
            margin-bottom: 8px;
            font-size: 0.85rem;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
            line-height: 1.4;
            height: 2.8em;
        }
        .product-price {
            font-size: 1rem;
            font-weight: 600;
            color: #28a745;
        }
        .stock-status {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 4px;
            font-size: 0.75rem;
            margin-left: 8px;
        }
        .stock-status.in-stock {
            background-color: #d4edda;
            color: #155724;
        }
        .stock-status.out-of-stock {
            background-color: #f8d7da;
            color: #721c24;
        }
        .product-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 8px;
        }
        .back-to-categories {
            background: #6c757d;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 5px;
            display: inline-flex;
            align-items: center;
            min-width: fit-content;
            font-size: 0.9rem;
            height: 34px; /* Sabit yükseklik */
        }
        .back-to-categories:hover {
            background: #5a6268;
            color: white;
        }
        .category-title-container {
            display: none;
            margin-bottom: 20px;
        }
        .category-title-container.show {
            display: block !important;
        }
        .header-section {
            background: #f8f9fa;
        }
        .header-section .d-flex {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .back-to-categories {
            background: #6c757d;
            color: white;
            border: none;
            padding: 6px 12px;
            border-radius: 5px;
            display: inline-flex;
            align-items: center;
            min-width: fit-content;
            font-size: 0.9rem;
            height: 34px; /* Sabit yükseklik */
        }
        .back-to-categories:hover {
            background: #5a6268;
            color: white;
        }
        .category-title-text {
            font-size: 1.2rem;
            font-weight: 500;
            color: #333;
            margin: 0;
            text-align: right;
            flex-grow: 1;
            display: flex;
            align-items: center;
            justify-content: flex-end;
            height: 34px; /* Buton ile aynı yükseklik */
        }
        .search-container {
            width: 100%;
        }
        #urunArama {
            border-right: none;
        }
        #aramaSifirla {
            border-left: none;
            background: #343a40; /* Koyu arka plan */
            color: white; /* Beyaz X ikonu */
            border-color: #ced4da; /* Input border rengi ile aynı */
        }
        #aramaSifirla:hover {
            background-color: #23272b; /* Hover durumunda biraz daha koyu */
            color: white;
        }
        /* Butonun active (tıklama) durumu için */
        #aramaSifirla:active {
            background-color: #1d2124;
            color: white;
        }
        /* Butonun focus durumu için */
        #aramaSifirla:focus {
            box-shadow: none;
            color: white;
        }
        .feedback-btn {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
        }
        .whatsapp-btn {
            position: fixed;
            bottom: 20px;
            left: 20px;
            z-index: 1000;
            background-color: #25D366;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 5px;
            display: flex;
            align-items: center;
            gap: 8px;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        .whatsapp-btn:hover {
            background-color: #128C7E;
            color: white;
            transform: scale(1.05);
        }
        
        /* Offcanvas Sidebar Styles */
        .offcanvas {
            max-width: 300px;
            background-color: #3b3b3b;
            padding: 0;
        }
        
        .welcome-header {
            background-color: #25426f;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .welcome-header h5 {
            color: white;
            margin: 0;
            font-weight: 600;
            font-family: 'Poppins', sans-serif;
        }
        
        .welcome-header .btn-close {
            background-color: transparent;
            filter: invert(1) grayscale(100%) brightness(200%);
        }
        
        .logo-section {
            background-color: #3b3b3b;
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid #4a4a4a;
        }
        
        .business-logo {
            width: 200px;
            height: auto;
            margin: 0 auto;
            display: block;
        }
        
        .business-name {
            color: white;
            margin-top: 10px;
            font-size: 18px;
            font-weight: 500;
        }
        
        .business-location {
            color: #aaa;
            font-size: 14px;
            margin-bottom: 5px;
        }
        
        .business-id {
            color: #aaa;
            font-size: 12px;
        }
        
        .info-section-title {
            color: white;
            padding: 15px 20px;
            font-weight: 500;
            margin: 0;
            border-bottom: 1px solid #4a4a4a;
            font-size: 14px;
        }
        
        .business-info {
            padding: 20px;
            color: white;
            background-color: #3b3b3b;
        }
        
        .business-info .info-item {
            margin-bottom: 15px;
            display: flex;
            align-items: flex-start;
            color: white;
        }
        
        .business-info .info-item i {
            width: 20px;
            margin-right: 10px;
            margin-top: 4px;
        }
        
        .business-info .info-item span {
            flex: 1;
            font-size: 14px;
        }
        
        .social-media-title {
            color: white;
            padding: 15px 20px 10px;
            font-weight: 500;
            margin: 0;
            font-size: 14px;
        }
        
        .social-links {
            padding: 0 20px 20px;
            background-color: #3b3b3b;
        }
        
        .social-links a {
            color: white;
            font-size: 14px;
            margin-bottom: 10px;
            text-decoration: none;
            display: block;
        }
        
        .footer-text {
            color: #aaa;
            font-size: 12px;
            text-align: center;
            padding: 20px;
            background-color: #3b3b3b;
            border-top: 1px solid #4a4a4a;
        }
        
        .navbar-toggler {
            padding: 0;
            border: none;
            background: transparent;
        }
        .navbar-toggler:focus {
            box-shadow: none;
        }
        .svg-inline--fa {
            color: white;
        }
        
        /* Dil seçici stilleri */
        .language-dropdown {
            position: relative;
            display: inline-block;
        }
        
        .language-menu {
            display: none;
            position: absolute;
            right: 0;
            top: 100%;
            background-color: #343a40;
            min-width: 160px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.2);
            z-index: 1000;
            border-radius: 4px;
            margin-top: 5px;
        }
        
        .language-menu.show {
            display: block;
        }
        
        .language-menu a {
            color: white;
            padding: 10px 16px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 14px;
        }
        
        .language-flag {
            width: 20px;
            height: 15px;
            object-fit: cover;
            border-radius: 2px;
        }
        
        .nav-icons {
            display: flex;
            gap: 5px;
            align-items: center;
        }
        
        .nav-icon-btn {
            background: none;
            border: none;
            color: white;
            font-size: 1.25rem;
            padding: 8px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
        }
        
        .nav-icon-btn:hover {
            opacity: 0.8;
            color: white;
            text-decoration: none;
        }
        
        @media (max-width: 767px) {
            .header-section {
                padding: 10px !important;
            }
            
            .header-section .d-flex {
                flex-direction: row !important;
                align-items: center !important;
                gap: 15px;
            }
            
            .back-to-categories {
                font-size: 0.85rem;
                padding: 6px 12px;
                margin: 0;
            }
            
            .category-title-text {
                font-size: 0.95rem;
                margin: 0;
                height: 34px; /* Buton ile aynı yükseklik korunuyor */
                display: flex;
                align-items: center;
                justify-content: flex-end;
            }
            
            .search-container {
                margin-top: 10px;
            }
        }
        .navbar {
            transition: all 0.3s ease;
        }
        .navbar .category-title-nav {
            color: white;
            font-size: 1.2rem;
            font-weight: 500;
            margin: 0;
            display: none;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        @media (max-width: 767px) {
            .navbar .category-title-nav {
                font-size: 1rem;
            }
        }
        /* Popüler Ürünler Carousel Styles */
        .popular-products-section {
            padding: 10px 0;
            position: relative;
            margin-bottom: 15px;
            background: #fff;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-radius: 10px;
            overflow: hidden;
        }
        
        .section-title {
            color: #333;
            font-weight: 600;
            text-align: center;
            margin-bottom: 10px;
            font-size: 1.5rem;
        }
        
        .popular-products-carousel {
            position: relative;
            padding: 0 30px;
            overflow: hidden;
            touch-action: pan-y pinch-zoom;
        }
        
        .popular-products-wrapper {
            display: flex;
            transition: transform 0.3s ease;
            gap: 10px;
            padding: 5px 0;
            cursor: grab;
        }
        
        .popular-products-wrapper:active {
            cursor: grabbing;
        }
        
        .popular-product-item {
            flex: 0 0 calc(33.333% - 7px);
            min-width: calc(33.333% - 7px);
            text-align: center;
            transition: all 0.3s ease;
            opacity: 0.7;
            transform: scale(0.95);
            padding: 2px;
        }
        
        .popular-product-item.active {
            opacity: 1;
            transform: scale(1);
        }
        
        .popular-product-image {
            width: 100%;
            height: 0;
            padding-bottom: 80%;
            position: relative;
            margin-bottom: 5px;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .popular-product-image img {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .popular-product-name {
            font-size: 0.75rem;
            font-weight: 500;
            color: #333;
            margin: 0;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            padding: 0 2px;
        }
        
        .carousel-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 20px;
            height: 20px;
            background: rgba(0,0,0,0.5);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            cursor: pointer;
            z-index: 10;
            transition: all 0.3s ease;
        }
        
        .carousel-nav:hover {
            background: rgba(0,0,0,0.7);
        }
        
        .carousel-nav.prev {
            left: 2px;
        }
        
        .carousel-nav.next {
            right: 2px;
        }
        
        @media (max-width: 767px) {
            .popular-product-item {
                flex: 0 0 calc(33.333% - 4px);
                min-width: calc(33.333% - 4px);
            }
            
            .popular-product-name {
                font-size: 0.7rem;
            }

            .popular-product-image {
                padding-bottom: 70%;
            }

            .carousel-nav {
                width: 18px;
                height: 18px;
            }

            .carousel-nav.prev {
                left: 2px;
            }
            
            .carousel-nav.next {
                right: 2px;
            }
        }

        /* Rating Modal Stilleri */
        .rating-modal .modal-content {
            border-radius: 10px;
            border: none;
        }

        .rating-modal .modal-header {
            background-color: #f8f9fa;
            border-bottom: 1px solid #dee2e6;
            border-radius: 10px 10px 0 0;
            padding: 15px 20px;
        }

        .rating-modal .modal-body {
            padding: 20px;
            text-align: center;
        }

        .rating-modal .rating-text {
            color: #666;
            margin-bottom: 20px;
            line-height: 1.5;
        }

        .rating-modal .rating-btn {
            background-color: #4285f4;
            color: white;
            padding: 10px 24px;
            border-radius: 5px;
            border: none;
            font-weight: 500;
            transition: background-color 0.3s ease;
            text-decoration: none;
            display: inline-block;
        }

        .rating-modal .rating-btn:hover {
            background-color: #3367d6;
            color: white;
            text-decoration: none;
        }

        /* Rating Modal içindeki mağaza görseli için stil güncellemesi */
        .rating-modal .store-image {
            width: 100%;
            height: 400px; /* 240px'den 400px'e çıkarıldı */
            object-fit: cover;
            border-radius: 15px;
            margin: 15px 0 20px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }

        /* Modal genişliğini artıralım ki görsel daha büyük gözüksün */
        .rating-modal .modal-dialog {
            max-width: 800px; /* 600px'den 800px'e çıkarıldı */
        }

        /* Mobil cihazlar için responsive ayarlar */
        @media (max-width: 767px) {
            .rating-modal .store-image {
                height: 300px; /* Mobil cihazlarda biraz daha küçük */
            }
            
            .rating-modal .modal-dialog {
                max-width: 95%; /* Mobil cihazlarda ekrana göre ayarla */
                margin: 10px auto;
            }
        }

        .search-container {
            position: relative;
        }

        #urunArama {
            padding-right: 40px;
        }

        #aramaSifirla {
            border-left: none;
        }

        #aramaSifirla:hover {
            background-color: #e9ecef;
        }

        /* Mobil için responsive ayarlar */
        @media (max-width: 767px) {
            .category-title-container .d-flex {
                flex-direction: column;
                gap: 10px;
            }
            
            .category-title-text {
                margin-left: 0;
                margin-top: 10px;
            }
            
            .search-container {
                width: 100%;
                margin-top: 10px;
            }
        }

        /* Ürün kartları arası boşluk */
        .product-section .row {
            margin: 0 -15px;
            row-gap: 20px; /* Dikey boşluk */
        }

        .product-section .col-md-6 {
            padding: 0 15px; /* Yatay boşluk */
        }

        .product-card {
            height: 100%;
            margin: 0; /* Önceki margin'ı kaldırıyoruz */
        }

        @media (max-width: 767px) {
            .product-section .row {
                row-gap: 15px; /* Mobilde daha az boşluk */
            }
            
            .product-section .col-md-6 {
                padding: 0 10px;
            }
        }

        /* Bottom Navigation Bar */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 65px;
            background: <?php echo $ayarlar['bottom_bar_bg_color'] ?? '#000000'; ?>;
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 8px 0;
            z-index: 1000;
        }

        .bottom-nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            color: white;
            text-decoration: none;
            font-size: 12px;
            gap: 4px;
        }

        .bottom-nav-item i {
            font-size: 20px;
        }

        .bottom-nav-item span {
            font-size: 11px;
        }

        .bottom-nav-item:hover {
            color: #fff;
            opacity: 0.8;
        }

        .feedback-circle {
            background: #dc3545;
            width: 65px;
            height: 65px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            bottom: 0px;
            padding: 0;
            box-shadow: 0 2px 8px rgba(0,0,0,0.3);
            margin-top: -20px;
        }

        .feedback-circle i {
            font-size: 28px;
            margin: 0;
            color: white;
        }

        .feedback-circle span {
            display: none;
        }

        /* WhatsApp butonunu gizle çünkü artık bottom bar'da */
        .whatsapp-btn {
            display: none;
        }

        /* Sayfa içeriğine bottom padding ekleyelim */
        body {
            padding-bottom: 70px;
        }

        /* Mobil görünümde bottom bar'ı göster ve feedback butonu gizle */
        @media (max-width: 767px) {
            .feedback-btn {
                display: none;
            }
        }

        @media (min-width: 768px) {
            .bottom-nav {
                display: none;
            }
            .whatsapp-btn {
                display: flex;
            }
            body {
                padding-bottom: 0;
            }
        }

        /* WiFi Modal Styles */
        .wifi-icon {
            font-size: 48px;
            color: #0d6efd;
            display: block;
        }

        .wifi-text {
            color: #666;
            font-size: 0.9rem;
        }

        .wifi-details {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            text-align: left;
        }

        .wifi-item {
            margin-bottom: 12px;
        }

        .wifi-item:last-child {
            margin-bottom: 0;
        }

        .wifi-label {
            font-weight: 500;
            color: #333;
            display: inline-block;
            width: 100px;
        }

        .wifi-value {
            color: #666;
        }

        /* Modal genel stilleri */
        .modal-content {
            border: none;
            border-radius: 15px;
        }

        .modal-header {
            border-bottom: 1px solid #dee2e6;
            padding: 15px 20px;
        }

        .modal-body {
            padding: 20px;
        }

        /* Dinamik renkler için özel stiller */
        .navbar {
            background-color: <?php echo $ayarlar['header_bg_color'] ?? '#343a40'; ?> !important;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1) !important;
        }

        /* Header ikonları için renk */
        .navbar-toggler .svg-inline--fa,
        .nav-icon-btn,
        .nav-icon-btn i {
            color: <?php echo $ayarlar['header_icon_color'] ?? '#ffffff'; ?> !important;
        }

        /* Bottom bar arkaplan ve ikonları */
        .bottom-nav {
            background-color: <?php echo $ayarlar['bottom_bar_bg_color'] ?? '#000000'; ?> !important;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1) !important;
        }

        .bottom-nav-item,
        .bottom-nav-item i,
        .bottom-nav-item span {
            color: <?php echo $ayarlar['bottom_bar_icon_color'] ?? '#ffffff'; ?> !important;
        }

        .bottom-nav-item:hover {
            color: <?php echo $ayarlar['bottom_bar_icon_color'] ?? '#ffffff'; ?> !important;
            opacity: 0.8;
        }

        .feedback-circle {
            background-color: <?php echo $ayarlar['feedback_circle_color'] ?? '#dc3545'; ?> !important;
        }

        /* Offcanvas içindeki elementlerin rengini otomatik ayarla */
        .offcanvas-header .btn-close {
            filter: none !important;
            opacity: 0.7;
        }

        .offcanvas-body {
            color: white;
        }

        .offcanvas .nav-link {
            color: white;
        }

        .offcanvas .nav-link:hover {
            color: rgba(255,255,255,0.8);
        }

        /* Beyaz arkaplan seçildiğinde border ekle */
        <?php if ($ayarlar['header_bg_color'] == '#ffffff' || $ayarlar['header_bg_color'] == '#FFFFFF'): ?>
        .navbar {
            border-bottom: 1px solid rgba(0,0,0,0.1) !important;
        }
        <?php endif; ?>

        <?php if ($ayarlar['bottom_bar_bg_color'] == '#ffffff' || $ayarlar['bottom_bar_bg_color'] == '#FFFFFF'): ?>
        .bottom-nav {
            border-top: 1px solid rgba(0,0,0,0.1) !important;
        }
        <?php endif; ?>

        /* Google Translate widget'ını düzenle */
        .goog-te-banner-frame,
        .goog-te-gadget {
            display: none !important;
        }

        body {
            top: 0 !important;
            position: relative !important;
        }

        /* Çeviri seçici gizle */
        .goog-te-combo {
            display: none !important;
        }

        /* Çeviri popup stillerini düzenle */
        .goog-tooltip,
        .goog-tooltip:hover {
            display: none !important;
        }

        .goog-text-highlight {
            background-color: transparent !important;
            border: none !important;
            box-shadow: none !important;
        }

        /* Google Translate widget konumu */
        #google_translate_element {
            position: fixed !important;
            bottom: -999999px !important;
            left: -999999px !important;
            z-index: -99999 !important;
            visibility: hidden !important;
            opacity: 0 !important;
        }

        /* Google Translate üst çubuğunu gizle */
        .skiptranslate {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
        }

        /* Google Translate iframe'i gizle */
        iframe.skiptranslate {
            display: none !important;
            visibility: hidden !important;
            opacity: 0 !important;
        }

        /* Offcanvas Menu Styles - Sağdaki menü için */
        .offcanvas-end {
            width: 300px;
            background-color: #ffffff !important;
        }

        .category-menu-image {
            width: 40px;
            height: 40px;
            object-fit: cover;
            border-radius: 8px;
        }

        .list-group-item {
            border: none;
            padding: 12px 16px;
            transition: all 0.2s ease;
            border-bottom: 1px solid rgba(0,0,0,0.05);
        }

        .list-group-item:last-child {
            border-bottom: none;
        }

        .list-group-item:hover {
            background-color: #f8f9fa;
            transform: translateX(5px);
        }

        .offcanvas-header {
            padding: 1rem;
            border-bottom: 1px solid #dee2e6;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .offcanvas-title {
            font-weight: 600;
            color: #333;
            margin: 0;
        }

        .offcanvas-body {
            padding: 1rem 0;
        }

        .list-group-item.active {
            background-color: #f8f9fa;
            color: #0d6efd;
            border-color: transparent;
        }

        /* Bottom Navigation Bar'daki menü ikonu için hover efekti */
        .bottom-nav-item:hover {
            opacity: 0.8;
            transform: translateY(-2px);
            transition: all 0.2s ease;
        }

        /* Soldaki işletme bilgileri offcanvas'ı için orijinal stiller */
        .offcanvas-start {
            background-color: #3b3b3b !important;
        }

        /* Soldaki offcanvas için beyaz text rengi */
        .offcanvas-start .offcanvas-body,
        .offcanvas-start .nav-link,
        .offcanvas-start .welcome-header h5,
        .offcanvas-start .business-info,
        .offcanvas-start .info-item,
        .offcanvas-start .social-links a {
            color: white !important;
        }

        /* Soldaki offcanvas için beyaz close button */
        .offcanvas-start .btn-close {
            filter: invert(1) grayscale(100%) brightness(200%) !important;
        }
    </style>
    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
</head>
<body>
    <!-- Loader -->
    <div class="loader-container">
        <div class="loader">
            <img src="uploads/<?php echo $ayarlar['logo'] ?? 'default_logo.png'; ?>" 
                 alt="<?php echo $ayarlar['isletme_adi'] ?? 'Logo'; ?>"
                 onerror="this.src='uploads/default_logo.png'">
        </div>
    </div>

    <nav class="navbar navbar-dark bg-dark">
        <div class="container position-relative py-2">
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebar">
                <svg class="svg-inline--fa fa-align-left fa-w-14" aria-hidden="true" focusable="false" data-prefix="fas" data-icon="align-left" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="24" height="24"><path fill="currentColor" d="M12.83 352h262.34A12.82 12.82 0 0 0 288 339.17v-38.34A12.82 12.82 0 0 0 275.17 288H12.83A12.82 12.82 0 0 0 0 300.83v38.34A12.82 12.82 0 0 0 12.83 352zm0-256h262.34A12.82 12.82 0 0 0 288 83.17V44.83A12.82 12.82 0 0 0 275.17 32H12.83A12.82 12.82 0 0 0 0 44.83v38.34A12.82 12.82 0 0 0 12.83 96zM432 160H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 256H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"></path></svg>
            </button>
            <a class="navbar-brand position-absolute start-50 translate-middle-x" href="index.php">
                <img src="uploads/<?php echo $ayarlar['logo'] ?? 'default_logo.png'; ?>" 
                     alt="<?php echo $ayarlar['isletme_adi'] ?? 'İşletme Logo'; ?>" 
                     style="height: 26px; width: auto;"
                     onerror="this.src='uploads/default_logo.png'"
                     loading="lazy">
            </a>
            <div class="nav-icons">
                <div class="language-dropdown">
                    <button class="nav-icon-btn" onclick="toggleLanguageMenu(event)">
                        <i class="fas fa-globe"></i>
                    </button>
                    <div class="language-menu" id="languageMenu">
                        <a href="#" class="active">
                            <img src="assets/flags/tr.svg" alt="Türkçe" class="language-flag">
                            Türkçe
                            <i class="fas fa-check ms-auto"></i>
                        </a>
                    </div>
                </div>
                <?php if(!empty($ayarlar['magaza_url'])): ?>
                <button class="nav-icon-btn" data-bs-toggle="modal" data-bs-target="#ratingModal">
                    <i class="fas fa-comment"></i>
                </button>
                <?php endif; ?>
            </div>
        </div>
    </nav>

    <!-- Offcanvas Sidebar -->
    <div class="offcanvas offcanvas-start" tabindex="-1" id="sidebar">
        <div class="welcome-header">
            <h5>Hoşgeldiniz!</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
        </div>
        
        <div class="logo-section">
            <img src="uploads/<?php echo $ayarlar['logo'] ?? 'default_logo.png'; ?>" 
                 alt="<?php echo $ayarlar['isletme_adi'] ?? 'İşletme Logo'; ?>" 
                 class="business-logo" 
                 onerror="this.src='uploads/default_logo.png'"
                 loading="lazy">
            <div class="business-name"><?php echo $ayarlar['isletme_adi'] ?? 'İşletme Adı'; ?></div>
        </div>
        
        <h5 class="info-section-title">İşletme Bilgileri</h5>
        
        <div class="business-info">
            <div class="info-item">
                <i class="fas fa-home"></i>
                <span><?php echo $ayarlar['adres'] ?? 'Adres bilgisi girilmemiş'; ?></span>
            </div>
            <div class="info-item">
                <i class="fas fa-clock"></i>
                <span><?php echo $ayarlar['haftaici_saatler'] ?? '07:30-23:00'; ?></span>
            </div>
            <div class="info-item">
                <i class="fas fa-envelope"></i>
                <span><?php echo $ayarlar['email'] ?? 'test@test.com'; ?></span>
            </div>
            <div class="info-item">
                <i class="fas fa-phone"></i>
                <span><?php echo $ayarlar['telefon'] ?? '05077200003'; ?></span>
            </div>
        </div>
        
        <h5 class="social-media-title">Sosyal Medya Hesaplarımız</h5>
        <div class="social-links">
            <?php if(!empty($ayarlar['instagram'])): ?>
                <a href="<?php echo $ayarlar['instagram']; ?>" target="_blank">
                    <i class="fab fa-instagram"></i> @<?php echo $ayarlar['instagram_kullanici']; ?>
                </a>
            <?php endif; ?>
            <?php if(!empty($ayarlar['facebook'])): ?>
                <a href="<?php echo $ayarlar['facebook']; ?>" target="_blank">
                    <i class="fab fa-facebook"></i> @<?php echo $ayarlar['facebook_kullanici']; ?>
                </a>
            <?php endif; ?>
            <?php if(!empty($ayarlar['twitter'])): ?>
                <a href="<?php echo $ayarlar['twitter']; ?>" target="_blank">
                    <i class="fab fa-twitter"></i> @<?php echo $ayarlar['twitter_kullanici']; ?>
                </a>
            <?php endif; ?>
        </div>
        
        <div class="footer-text">
            <?php echo $ayarlar['copyright'] ?? 'QrMenu.Rest ile Oluşturulmuştur.<br>© 2020-2025'; ?>
        </div>
    </div>

    <div class="container my-4">
        <!-- En Çok Sevilenler bölümü -->
        <div class="popular-products-section">
            <h4 class="section-title">En Çok Sevilenler</h4>
            <div class="popular-products-carousel">
                <div class="carousel-nav prev">
                    <i class="fas fa-chevron-left"></i>
                </div>
                <div class="carousel-nav next">
                    <i class="fas fa-chevron-right"></i>
                </div>
                <div class="popular-products-wrapper">
                    <?php
                    // Popüler ürünleri çek
                    $popular_stmt = $conn->query("SELECT * FROM urunler WHERE stok_durumu = 1 ORDER BY begeni_sayisi DESC LIMIT 10");
                    $popular_products = $popular_stmt->fetchAll(PDO::FETCH_ASSOC);
                    
                    // Orijinal ürünleri göster
                    foreach($popular_products as $popular): ?>
                        <div class="popular-product-item" onclick="showProductDetails(<?php echo $popular['id']; ?>)">
                            <div class="popular-product-image">
                                <?php if($popular['resim']): ?>
                                    <img src="uploads/<?php echo $popular['resim']; ?>" 
                                         alt="<?php echo $popular['urun_adi']; ?>"
                                         loading="lazy">
                                <?php else: ?>
                                    <img src="uploads/default.jpg" 
                                         alt="Varsayılan ürün resmi"
                                         loading="lazy">
                                <?php endif; ?>
                            </div>
                            <div class="popular-product-name"><?php echo $popular['urun_adi']; ?></div>
                        </div>
                    <?php endforeach; ?>
                    
                    <!-- Kopyalanmış ürünler (sonsuz döngü için) -->
                    <?php foreach($popular_products as $popular): ?>
                        <div class="popular-product-item" onclick="showProductDetails(<?php echo $popular['id']; ?>)">
                            <div class="popular-product-image">
                                <?php if($popular['resim']): ?>
                                    <img src="uploads/<?php echo $popular['resim']; ?>" 
                                         alt="<?php echo $popular['urun_adi']; ?>"
                                         loading="lazy">
                                <?php else: ?>
                                    <img src="uploads/default.jpg" 
                                         alt="Varsayılan ürün resmi"
                                         loading="lazy">
                                <?php endif; ?>
                            </div>
                            <div class="popular-product-name"><?php echo $popular['urun_adi']; ?></div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- WhatsApp Butonu -->
        <?php if(!empty($ayarlar['whatsapp'])): ?>
            <?php
            // Telefon numarasını temizle (sadece rakamları al)
            $whatsapp_number = preg_replace('/[^0-9]/', '', $ayarlar['whatsapp']);
            
            // Eğer numara 0 ile başlıyorsa, 0'ı kaldır ve 90 ekle
            if (substr($whatsapp_number, 0, 1) === '0') {
                $whatsapp_number = '90' . substr($whatsapp_number, 1);
            }
            // Eğer numara 5 ile başlıyorsa başına 90 ekle
            else if (substr($whatsapp_number, 0, 1) === '5') {
                $whatsapp_number = '90' . $whatsapp_number;
            }
            ?>
            <a href="https://wa.me/<?php echo $whatsapp_number; ?>" 
               target="_blank" 
               class="whatsapp-btn">
                <i class="fab fa-whatsapp"></i>
                <span>WhatsApp</span>
            </a>
        <?php endif; ?>

        <!-- Kategoriler Bölümü -->
        <div class="categories-container">
            <div class="row">
                <?php
                $stmt = $conn->query("SELECT * FROM kategoriler ORDER BY id ASC");
                while($kategori = $stmt->fetch(PDO::FETCH_ASSOC)):
                ?>
                <div class="col-6">
                    <div class="category-card" onclick="showProducts(<?php echo $kategori['id']; ?>)">
                        <?php
                        $webp_path = 'uploads/kategori_' . $kategori['id'] . '.webp';
                        $jpg_path = 'uploads/kategori_' . $kategori['id'] . '.jpg';
                        $image_path = file_exists($webp_path) ? $webp_path : $jpg_path;
                        ?>
                        <img src="<?php echo $image_path; ?>" 
                             onerror="this.src='uploads/default_category.jpg'" 
                             class="category-image" 
                             alt="<?php echo $kategori['kategori_adi']; ?>"
                             loading="eager"
                             fetchpriority="high">
                        <div class="category-overlay">
                            <h3 class="category-title"><?php echo $kategori['kategori_adi']; ?></h3>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>

        <!-- Kategori başlığı ve arama bölümü -->
        <div class="category-title-container">
            <div class="header-section bg-light p-3 rounded mb-3">
                <div class="d-flex justify-content-between align-items-center">
                    <button onclick="showCategories()" class="btn back-to-categories">
                        <i class="fas fa-arrow-left me-2"></i> Geri
                    </button>
                    <h5 class="category-title-text mb-0"></h5>
                </div>
            </div>
            <div class="search-container">
                <div class="input-group">
                    <input type="text" class="form-control" id="urunArama" placeholder="Ürün ara...">
                    <button class="btn btn-outline-secondary" type="button" id="aramaSifirla">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Şikayet/Geri Bildirim Butonu -->
        <button class="btn btn-primary feedback-btn" data-bs-toggle="modal" data-bs-target="#feedbackModal">
            <i class="fas fa-comment-alt me-2"></i> Geri Bildirim
        </button>

        <!-- Ürünler Bölümü -->
        <?php
        $stmt = $conn->query("SELECT * FROM kategoriler ORDER BY id ASC");
        while($kategori = $stmt->fetch(PDO::FETCH_ASSOC)):
        ?>
        <div class="product-section" id="category-<?php echo $kategori['id']; ?>" data-category-name="<?php echo $kategori['kategori_adi']; ?>">
            <div class="row">
                <?php
                $urun_stmt = $conn->prepare("SELECT * FROM urunler WHERE kategori_id = ? ORDER BY urun_adi");
                $urun_stmt->execute([$kategori['id']]);
                while($urun = $urun_stmt->fetch(PDO::FETCH_ASSOC)):
                ?>
                <div class="col-md-6">
                    <div class="card product-card <?php echo $urun['stok_durumu'] == 0 ? 'out-of-stock' : ''; ?>">
                        <div class="d-flex">
                            <div class="product-image-container">
                                <?php if($urun['resim']): ?>
                                    <img src="uploads/<?php echo $urun['resim']; ?>" 
                                         class="product-image" 
                                         alt="<?php echo $urun['urun_adi']; ?>"
                                         loading="lazy">
                                <?php else: ?>
                                    <img src="uploads/default.jpg" 
                                         class="product-image" 
                                         alt="Varsayılan ürün resmi"
                                         loading="lazy">
                                <?php endif; ?>
                            </div>
                            <div class="product-details">
                                <h5 class="product-title"><?php echo $urun['urun_adi']; ?></h5>
                                <p class="product-description"><?php echo $urun['aciklama']; ?></p>
                                <div class="product-footer">
                                    <div>
                                        <span class="product-price"><?php echo number_format($urun['fiyat'], 2); ?> ₺</span>
                                        <?php if($urun['stok_durumu'] == 0): ?>
                                            <span class="stock-status out-of-stock">Stokta Yok</span>
                                        <?php else: ?>
                                            <span class="stock-status in-stock">Stokta Var</span>
                                        <?php endif; ?>
                                    </div>
                                    <button class="btn btn-sm btn-outline-primary" onclick="showProductDetails(<?php echo $urun['id']; ?>)">
                                        <i class="fas fa-info-circle"></i> Detaylar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
        <?php endwhile; ?>
    </div>

    <!-- Geri Bildirim Modal -->
    <div class="modal fade" id="feedbackModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Geri Bildirim Formu</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="feedbackForm" method="POST" action="submit_feedback.php">
                        <div class="mb-3">
                            <label for="musteri_adi" class="form-label">Adınız</label>
                            <input type="text" class="form-control" id="musteri_adi" name="musteri_adi" required>
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">E-posta Adresiniz</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label for="konu" class="form-label">Konu</label>
                            <input type="text" class="form-control" id="konu" name="konu" required>
                        </div>
                        <div class="mb-3">
                            <label for="mesaj" class="form-label">Mesajınız</label>
                            <textarea class="form-control" id="mesaj" name="mesaj" rows="4" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Gönder</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Ürün Detay Modal -->
    <div class="modal fade" id="productModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ürün Detayları</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body" id="productModalContent">
                    <!-- İçerik AJAX ile doldurulacak -->
                </div>
            </div>
        </div>
    </div>

    <!-- Rating Modal -->
    <div class="modal fade rating-modal" id="ratingModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Bizi Değerlendir</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p class="rating-text">
                        Eğer bizi değerlendirmek isterseniz hemen Google Yorumlar'da yorum yaparak değerlendirebilirsiniz.
                    </p>
                    <img src="uploads/<?php echo $ayarlar['magaza_foto'] ?? 'default_store.jpg'; ?>" 
                         alt="<?php echo $ayarlar['isletme_adi'] ?? 'Mağaza'; ?>" 
                         class="store-image"
                         onerror="this.src='uploads/default_store.jpg'"
                         loading="lazy">
                    <a href="<?php echo $ayarlar['magaza_url']; ?>" 
                       target="_blank" 
                       class="rating-btn">
                        Google'da Değerlendir
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- WiFi Modal -->
    <div class="modal fade" id="wifiModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">WiFi Ağına Bağlan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <i class="fas fa-wifi wifi-icon mb-3"></i>
                    <?php if(!empty($ayarlar['wifi_ag_adi']) && !empty($ayarlar['wifi_sifre'])): ?>
                        <p class="wifi-text mb-4">WiFi ağına bağlanmak için aşağıdaki bilgileri kullanabilirsiniz:</p>
                        <div class="wifi-details">
                            <div class="wifi-item">
                                <span class="wifi-label">Ağ Adı:</span>
                                <span class="wifi-value"><?php echo htmlspecialchars($ayarlar['wifi_ag_adi']); ?></span>
                            </div>
                            <div class="wifi-item">
                                <span class="wifi-label">Şifre:</span>
                                <span class="wifi-value"><?php echo htmlspecialchars($ayarlar['wifi_sifre']); ?></span>
                            </div>
                            <?php if(!empty($ayarlar['wifi_guvenlik'])): ?>
                                <div class="wifi-item">
                                    <span class="wifi-label">Güvenlik:</span>
                                    <span class="wifi-value"><?php echo htmlspecialchars($ayarlar['wifi_guvenlik']); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <p class="wifi-text mb-4">WiFi bilgileri henüz ayarlanmamış.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Bottom Navigation Bar -->
    <div class="bottom-nav">
        <a href="#" class="bottom-nav-item" onclick="showCategories()">
            <i class="fas fa-home"></i>
            <span>Anasayfa</span>
        </a>
        <?php if(!empty($ayarlar['whatsapp'])): ?>
            <a href="https://wa.me/<?php echo $whatsapp_number; ?>" class="bottom-nav-item" target="_blank">
                <i class="fab fa-whatsapp"></i>
                <span>WhatsApp</span>
            </a>
        <?php endif; ?>
        <a href="#" class="bottom-nav-item feedback-circle" data-bs-toggle="modal" data-bs-target="#feedbackModal">
            <i class="fas fa-comment"></i>
        </a>
        <a href="#" class="bottom-nav-item" data-bs-toggle="modal" data-bs-target="#wifiModal">
            <i class="fas fa-wifi"></i>
            <span>WiFi</span>
        </a>
        <a href="#" class="bottom-nav-item" data-bs-toggle="offcanvas" data-bs-target="#menuOffcanvas">
            <i class="fas fa-bars"></i>
            <span>Menü</span>
        </a>
    </div>

    <!-- Bottom Navigation Bar'dan önce Offcanvas Menu ekleyelim -->
    <div class="offcanvas offcanvas-end" tabindex="-1" id="menuOffcanvas">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title">Kategoriler</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
        </div>
        <div class="offcanvas-body">
            <div class="list-group">
                <?php
                $stmt = $conn->query("SELECT * FROM kategoriler ORDER BY id ASC");
                while($kategori = $stmt->fetch(PDO::FETCH_ASSOC)):
                ?>
                <a href="#" class="list-group-item list-group-item-action d-flex align-items-center" 
                   onclick="showProducts(<?php echo $kategori['id']; ?>); 
                            bootstrap.Offcanvas.getInstance(document.getElementById('menuOffcanvas')).hide();">
                    <?php
                    $webp_path = 'uploads/kategori_' . $kategori['id'] . '.webp';
                    $jpg_path = 'uploads/kategori_' . $kategori['id'] . '.jpg';
                    $image_path = file_exists($webp_path) ? $webp_path : $jpg_path;
                    ?>
                    <img src="<?php echo $image_path; ?>" 
                         onerror="this.src='uploads/default_category.jpg'" 
                         class="category-menu-image me-3" 
                         alt="<?php echo $kategori['kategori_adi']; ?>"
                         loading="lazy">
                    <?php echo $kategori['kategori_adi']; ?>
                </a>
                <?php endwhile; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // Sayfa yüklendiğinde
        $(document).ready(function() {
            // Loader'ı gizle
            setTimeout(function() {
                $('.loader-container').addClass('fade-out');
                setTimeout(function() {
                    $('.loader-container').hide();
                }, 500);
            }, 1000);

            // Başlangıçta kategoriler görünür, geri dön butonu ve ürünler gizli
            $('.categories-container').show();
            $('.category-title-container').hide();
            $('.product-section').hide();

            // Carousel işlemleri
            const carousel = $('.popular-products-carousel');
            const wrapper = $('.popular-products-wrapper');
            const items = $('.popular-product-item');
            let currentIndex = 0;
            const totalItems = items.length / 2;
            const visibleItems = window.innerWidth > 767 ? 3 : 2;
            
            // Touch/Mouse events için değişkenler
            let isDragging = false;
            let startPos = 0;
            let currentTranslate = 0;
            let prevTranslate = 0;
            
            function initializeCarousel() {
                items.removeClass('active');
                for(let i = 0; i < visibleItems; i++) {
                    items.eq(i).addClass('active');
                }
                wrapper.css('transform', 'translateX(0)');
            }
            
            function updateActiveItems() {
                items.removeClass('active');
                for(let i = 0; i < visibleItems; i++) {
                    const index = (currentIndex + i) % totalItems;
                    items.eq(index).addClass('active');
                    items.eq(index + totalItems).addClass('active');
                }
            }
            
            // Touch events
            wrapper.on('mousedown touchstart', dragStart);
            wrapper.on('mousemove touchmove', drag);
            wrapper.on('mouseup touchend', dragEnd);
            wrapper.on('mouseleave', dragEnd);
            
            // Arrow navigation
            $('.carousel-nav.prev').on('click', function() {
                if (!isDragging) {
                    currentIndex = Math.max(0, currentIndex - 1);
                    const itemWidth = items.first().outerWidth(true);
                    prevTranslate = -(currentIndex * itemWidth);
                    currentTranslate = prevTranslate;
                    wrapper.css({
                        'transition': 'transform 0.3s ease',
                        'transform': `translateX(${currentTranslate}px)`
                    });
                    updateActiveItems();
                }
            });
            
            $('.carousel-nav.next').on('click', function() {
                if (!isDragging) {
                    currentIndex = Math.min(totalItems - 1, currentIndex + 1);
                    const itemWidth = items.first().outerWidth(true);
                    if (currentIndex >= totalItems) {
                        currentIndex = 0;
                        wrapper.css({
                            'transition': 'none',
                            'transform': 'translateX(0)'
                        });
                        wrapper[0].offsetHeight;
                    }
                    prevTranslate = -(currentIndex * itemWidth);
                    currentTranslate = prevTranslate;
                    wrapper.css({
                        'transition': 'transform 0.3s ease',
                        'transform': `translateX(${currentTranslate}px)`
                    });
                    updateActiveItems();
                }
            });
            
            function dragStart(e) {
                isDragging = true;
                startPos = getPositionX(e);
                wrapper.css('transition', 'none');
            }
            
            function drag(e) {
                if (!isDragging) return;
                e.preventDefault();
                const currentPosition = getPositionX(e);
                const diff = currentPosition - startPos;
                currentTranslate = prevTranslate + diff;
                wrapper.css('transform', `translateX(${currentTranslate}px)`);
            }
            
            function dragEnd() {
                if (!isDragging) return;
                isDragging = false;
                wrapper.css('transition', 'transform 0.3s ease');
                
                const itemWidth = items.first().outerWidth(true);
                const moveBy = currentTranslate - prevTranslate;
                
                if (Math.abs(moveBy) > itemWidth / 4) {
                    if (moveBy > 0) {
                        currentIndex--;
                    } else {
                        currentIndex++;
                    }
                }
                
                if (currentIndex < 0) currentIndex = 0;
                if (currentIndex >= totalItems) currentIndex = totalItems - 1;
                
                prevTranslate = -(currentIndex * itemWidth);
                currentTranslate = prevTranslate;
                
                wrapper.css('transform', `translateX(${currentTranslate}px)`);
                updateActiveItems();
            }
            
            function getPositionX(e) {
                return e.type.includes('mouse') ? e.pageX : e.touches[0].clientX;
            }
            
            let autoScrollInterval;
            
            function startAutoScroll() {
                autoScrollInterval = setInterval(() => {
                    if (!isDragging) {
                        const itemWidth = items.first().outerWidth(true);
                        currentIndex++;
                        if (currentIndex >= totalItems) {
                            currentIndex = 0;
                            wrapper.css({
                                'transition': 'none',
                                'transform': 'translateX(0)'
                            });
                            wrapper[0].offsetHeight;
                        }
                        prevTranslate = -(currentIndex * itemWidth);
                        currentTranslate = prevTranslate;
                        wrapper.css({
                            'transition': 'transform 0.3s ease',
                            'transform': `translateX(${currentTranslate}px)`
                        });
                        updateActiveItems();
                    }
                }, 3000);
            }
            
            function stopAutoScroll() {
                clearInterval(autoScrollInterval);
            }
            
            carousel.on('mouseenter touchstart', stopAutoScroll);
            carousel.on('mouseleave touchend', startAutoScroll);
            
            initializeCarousel();
            setTimeout(startAutoScroll, 1000);
            
            $(window).on('resize', () => {
                currentIndex = 0;
                prevTranslate = 0;
                currentTranslate = 0;
                initializeCarousel();
            });
        });

        let activeCategory = null;

        function showProducts(categoryId) {
            activeCategory = categoryId;
            $('.categories-container').hide();
            $('.product-section').hide();
            $('.category-title-container').addClass('show');
            $('.category-title-text').text($('#category-' + categoryId).data('category-name'));
            $('#category-' + categoryId).show();
            $('.popular-products-section').hide();
            
            // Arama kutusunu temizle
            $('#urunArama').val('');
            
            window.scrollTo(0, 0);
        }

        function showCategories() {
            $('.product-section').hide();
            $('.category-title-container').removeClass('show');
            $('.categories-container').show();
            
            // En Çok Sevilenler bölümünü göster
            $('.popular-products-section').show();
            
            window.scrollTo(0, 0);
        }

        function showProductDetails(productId) {
            $.get('get_product_details.php?id=' + productId, function(data) {
                $('#productModalContent').html(data);
                $('#productModal').modal('show');
            });
        }

        // Geri bildirim formu gönderimi
        $('#feedbackForm').on('submit', function(e) {
            e.preventDefault();
            $.post('submit_feedback.php', $(this).serialize(), function(response) {
                if(response.success) {
                    alert('Geri bildiriminiz için teşekkür ederiz!');
                    $('#feedbackModal').modal('hide');
                    $('#feedbackForm')[0].reset();
                } else {
                    alert('Bir hata oluştu. Lütfen tekrar deneyiniz.');
                }
            }, 'json');
        });

        // Ürün değerlendirme fonksiyonu
        function rateProduct(productId, type) {
            $.post('rate_product.php', {
                id: productId,
                type: type
            }, function(response) {
                if(response.success) {
                    // Beğeni/beğenmeme sayılarını güncelle
                    $('.like-count').text(response.likes);
                    $('.dislike-count').text(response.dislikes);
                    
                    // Başarılı mesajını göster
                    const alertDiv = $('<div>')
                        .addClass('alert alert-success alert-dismissible fade show')
                        .attr('role', 'alert')
                        .html(`
                            ${response.message}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        `);
                    
                    $('#productModalContent').prepend(alertDiv);
                    
                    // 3 saniye sonra alert'i kaldır
                    setTimeout(() => {
                        alertDiv.alert('close');
                    }, 3000);
                } else {
                    alert(response.message);
                }
            }, 'json');
        }

        // Dil menüsü için toggle fonksiyonu
        function toggleLanguageMenu(event) {
            event.stopPropagation(); // Event'in diğer elementlere yayılmasını engelle
            const menu = document.getElementById('languageMenu');
            menu.classList.toggle('show');
        }
        
        // Sayfa herhangi bir yerine tıklandığında dil menüsünü kapat
        document.addEventListener('click', function(event) {
            const menu = document.getElementById('languageMenu');
            const languageBtn = document.querySelector('.language-dropdown .nav-icon-btn');
            
            if (!menu.contains(event.target) && !languageBtn.contains(event.target)) {
                menu.classList.remove('show');
            }
        });

        // Arama fonksiyonu
        function searchProducts(searchTerm) {
            if (!activeCategory) return;
            
            const categoryProducts = $(`#category-${activeCategory} .col-md-6`);
            
            if (!searchTerm) {
                categoryProducts.show();
                return;
            }
            
            searchTerm = searchTerm.toLowerCase();
            
            categoryProducts.each(function() {
                const productName = $(this).find('.product-title').text().toLowerCase();
                const productDesc = $(this).find('.product-description').text().toLowerCase();
                
                if (productName.includes(searchTerm) || productDesc.includes(searchTerm)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        }

        // Arama olayları
        $(document).ready(function() {
            let searchTimeout;
            
            $('#urunArama').on('input', function() {
                clearTimeout(searchTimeout);
                const searchTerm = $(this).val();
                
                // 300ms bekle ve sonra aramayı yap
                searchTimeout = setTimeout(() => {
                    searchProducts(searchTerm);
                }, 300);
            });
            
            // Arama sıfırlama butonu
            $('#aramaSifirla').on('click', function() {
                $('#urunArama').val('');
                searchProducts('');
            });
        });

        // Google Translate fonksiyonları
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({
                pageLanguage: 'tr',
                includedLanguages: 'en,tr,ar,ru',
                autoDisplay: false,
                layout: google.translate.TranslateElement.InlineLayout.NONE
            }, 'google_translate_element');
        }

        // Dil değiştirme fonksiyonu
        function changeLanguage(lang) {
            // Türkçe seçildiğinde
            if (lang === 'tr') {
                // LocalStorage'dan dil seçimini kaldır
                localStorage.removeItem('selectedLanguage');
                
                // Sayfayı yeniden yükle
                window.location.reload();
                return false;
            }
            
            // Diğer diller için
            const element = document.getElementById('google_translate_element');
            if (!element) return false;

            // Select elementini bul ve dili değiştir
            const selectElement = element.getElementsByTagName('select')[0];
            if (selectElement) {
                selectElement.value = lang;
                selectElement.dispatchEvent(new Event('change'));
                
                // Aktif dili güncelle
                updateLanguageUI(lang);
                
                // Seçili dili localStorage'a kaydet
                localStorage.setItem('selectedLanguage', lang);
            }

            return false;
        }

        // Dil UI'ını güncelle
        function updateLanguageUI(lang) {
            // Tüm dil seçeneklerinden active class ve tik işaretini kaldır
            document.querySelectorAll('.language-menu a').forEach(a => {
                a.classList.remove('active');
                const checkIcon = a.querySelector('.fa-check');
                if (checkIcon) checkIcon.remove();
            });
            
            // Seçili dile active class ve tik işareti ekle
            const selectedLang = document.querySelector(`.language-menu a[onclick*="'${lang}'"]`);
            if (selectedLang) {
                selectedLang.classList.add('active');
                if (!selectedLang.querySelector('.fa-check')) {
                    selectedLang.innerHTML += '<i class="fas fa-check ms-auto"></i>';
                }
            }
            
            // Dil menüsünü kapat
            document.getElementById('languageMenu').classList.remove('show');
            
            // Seçili dili localStorage'a kaydet
            localStorage.setItem('selectedLanguage', lang);
        }

        // Sayfa yüklendiğinde
        document.addEventListener('DOMContentLoaded', function() {
            // Google Translate elementi için div ekle
            if (!document.getElementById('google_translate_element')) {
                const div = document.createElement('div');
                div.id = 'google_translate_element';
                div.style.display = 'none';
                document.body.appendChild(div);
            }
            
            // Sayfa yüklendiğinde dil seçimini kontrol et
            const savedLang = localStorage.getItem('selectedLanguage');
            if (savedLang && savedLang !== 'tr') {
                setTimeout(() => {
                    changeLanguage(savedLang);
                }, 1000);
            } else {
                // Türkçe için tik işaretini ekle
                const trLink = document.querySelector('.language-menu a[onclick*="\'tr\'"]');
                if (trLink && !trLink.querySelector('.fa-check')) {
                    trLink.classList.add('active');
                    trLink.innerHTML += '<i class="fas fa-check ms-auto"></i>';
                }
            }
        });
    </script>
</body>
</html> 