<?php
require_once 'config/db.php';

header('Content-Type: application/json');

if(isset($_POST['id']) && isset($_POST['type'])) {
    $id = intval($_POST['id']);
    $type = $_POST['type'];
    $kullanici_ip = $_SERVER['REMOTE_ADDR'];
    
    // Geçerli değerlendirme tiplerini kontrol et
    if(!in_array($type, ['like', 'dislike'])) {
        echo json_encode(['success' => false, 'message' => 'Geçersiz değerlendirme tipi']);
        exit;
    }
    
    try {
        // Kullanıcının daha önce değerlendirme yapıp yapmadığını kontrol et
        $stmt = $conn->prepare("SELECT id FROM urun_degerlendirmeleri WHERE urun_id = ? AND kullanici_ip = ?");
        $stmt->execute([$id, $kullanici_ip]);
        
        if($stmt->rowCount() > 0) {
            echo json_encode(['success' => false, 'message' => 'Bu ürünü daha önce değerlendirdiniz']);
            exit;
        }
        
        // Ürünü kontrol et
        $stmt = $conn->prepare("SELECT id, begeni_sayisi, begenmeme_sayisi FROM urunler WHERE id = ?");
        $stmt->execute([$id]);
        $urun = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if(!$urun) {
            echo json_encode(['success' => false, 'message' => 'Ürün bulunamadı']);
            exit;
        }
        
        // Değerlendirmeyi kaydet
        $stmt = $conn->prepare("INSERT INTO urun_degerlendirmeleri (urun_id, kullanici_ip, degerlendirme_tipi) VALUES (?, ?, ?)");
        $stmt->execute([$id, $kullanici_ip, $type]);
        
        // Ürün değerlendirme sayısını güncelle
        if($type === 'like') {
            $stmt = $conn->prepare("UPDATE urunler SET begeni_sayisi = begeni_sayisi + 1 WHERE id = ?");
        } else {
            $stmt = $conn->prepare("UPDATE urunler SET begenmeme_sayisi = begenmeme_sayisi + 1 WHERE id = ?");
        }
        
        $stmt->execute([$id]);
        
        // Güncel değerleri al
        $stmt = $conn->prepare("SELECT begeni_sayisi, begenmeme_sayisi FROM urunler WHERE id = ?");
        $stmt->execute([$id]);
        $yeni_degerler = $stmt->fetch(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'message' => 'Değerlendirmeniz kaydedildi',
            'likes' => $yeni_degerler['begeni_sayisi'],
            'dislikes' => $yeni_degerler['begenmeme_sayisi']
        ]);
        
    } catch(PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Bir hata oluştu']);
    }
    
} else {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek']);
}
?> 